package com.redhat.installer.tests.postinstall;

import com.redhat.installer.postinstall.LogIzPackVars;
import com.redhat.installer.tests.ProcessPanelTester;
import com.redhat.installer.tests.TestUtils;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import java.util.*;

import static junit.framework.TestCase.assertEquals;
import static junit.framework.TestCase.assertTrue;

/**
 * Created by thauser on 2/5/14.
 */
public class LogIzPackVarsTest extends ProcessPanelTester {
    private static final String IZPACK_LOGMSG = "LogIzPackVars.message " + TestUtils.INSTALL_PATH + "/" + TestUtils.testLogFilename;
    LogIzPackVars lipv;

    @BeforeClass
    public static void specificInit() throws Exception {
        idata.langpack = TestUtils.createMockLangpack("LogIzPackVars.message");
    }

    @Before
    public void setUp() throws Exception {
        lipv = new LogIzPackVars();
    }

    @After
    public void tearDown() throws Exception {
        lipv = null;
    }

    @Test
    public void testLogFileContents() throws Exception {
        TestUtils.createNewEmptyFile("");  // not sure why TestUtils.createMockDirectory() throws an exception here.
        addToIdata("variable1", "variable2", "variable3", "variable4", "testpassword", "testpwd", "testpass");
		String val = "jboss-brms-installer-6.0.1.GA-redhat-1.jar auto.xml -variables adminPassword=********,brms.password=********,Pwd=********";
        idata.setVariable("SYSTEM_sun_java_command",val);
        lipv.run(handler, null);
        Set<String> result = TestUtils.getFileLinesAsSet(TestUtils.testLogPath);
        Set<String> expected = getIdataVariablesAsSet();
        expected.add(IZPACK_LOGMSG);
        assertEquals(expected, result);
    }

    @Test
    public void testSystemSunJavaCommandObfuscation() throws Exception {
        String val = "jboss-brms-installer-6.0.1.GA-redhat-1.jar auto.xml -variables adminPassword=admin123$,brms.password=admin123$,Pwd=mypass123";
        String expectedCensoredVal = "jboss-brms-installer-6.0.1.GA-redhat-1.jar auto.xml -variables adminPassword=********,brms.password=********,Pwd=********";

        TestUtils.createNewEmptyFile("");
        idata.setVariable("SYSTEM_sun_java_command",val);
        lipv.run(handler, null);
        Set<String> result = TestUtils.getFileLinesAsSet(TestUtils.testLogPath);
        for (String var : result) {
            if (var.contains("SYSTEM_sun_java_command")) {
                assertEquals("SYSTEM_sun_java_command = " + expectedCensoredVal, var);
                System.out.println(var);
            }
        }

    }

    @Test
    public void testDbDialectSetting() throws Exception {
        idata.setVariable("db.dialect", "H2Dialect");
        lipv.run(handler, null);
        assertEquals(System.getProperty("db.dialect"), "H2Dialect");
    }

    public void addToIdata(String ... args){
        for (String s : args){
            idata.setVariable(s,s);
        }
    }

    public Set<String> getIdataVariablesAsSet(){
        Set<String> set = new HashSet<String>();
        Properties vars = idata.getVariables();
        Set<Object> keys = vars.keySet();
        for (Object key : keys){
            String strKey = (String) key;
            if (strKey.contains("password") || strKey.contains("pass") || strKey.contains("pwd"))
                continue;
            set.add(strKey + " = " + vars.get(strKey));
        }
        return set;
    }

    @Override
    public void testProcessPanelInstantiation() {

    }
}
