package com.redhat.installer.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

/**
 * Not actually a validator! Implemented as one since actions don't
 * seem to work at all. Very hacky.
 *
 * This is supposed to run after proper validation.
 *
 * Action for bridging the two variables set by SocketBindingPanel
 * and writing the result into variable standalone.port-offset
 *
 * @author Alex Szczuczko <aszczucz@redhat.com>
 */
public class OffsetVariableBridgeValidator implements Validator {

    public boolean validate(ProcessingClient client) {
        //DEBUG
        System.out.println("DEBUG - OVBV - START");

        // We're not interested in the client data, just use AID
        final AutomatedInstallData adata = AutomatedInstallData.getInstance();

        // Grab the two variables set by the panel elements
        // radio control
        final String var_pOT = adata.getVariable("portOffsetType");
        // text box
        final String var_cPO = adata.getVariable("configurePortOffset");

        System.out.println("DEBUG - OVBV - AFTER final START");

        Integer portOffsetValue = new Integer(0);

        System.out.println("DEBUG - OVBV - AFTER Integer START");

        try {
            if (var_pOT.equals("1")) {
                portOffsetValue = Integer.valueOf(var_cPO);

            } else if (var_pOT.equals("100")) {
                portOffsetValue = Integer.valueOf(var_cPO);

            } else if (var_pOT.equals("specify")) {
                // Expecting var_pOT equals 0, or var_pOT is null
                if (! var_cPO.isEmpty() ) {
                    portOffsetValue = Integer.valueOf(var_cPO);
                } else {
                    // var_cPO is null!
                    // Shouldn't get here
                    return false;
                }

            } else {
                // var_pOT is null!
                // Shouldn't get here
                return false;
            }
        } catch (NumberFormatException e) {
            // The number should have passed validation already.
            // Conversion is performed to ensure that the values are at least integers.
            // Shouldn't get here
            return false;
        }

        // If we got errors anywhere portOffsetValue remains at the default value 0
        adata.setVariable("standalone.port-offset", portOffsetValue.toString());

        //DEBUG
        System.out.println("DEBUG - OVBV - END");

        return false; //debug is false to see if it works at all (should stop always)
    }
}
