package com.redhat.installer.settings;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.redhat.installer.postinstall.ProcessPanelHelper;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Map;


/**
 * @author dcheung@redhat.com, dmondega@redhat.com
 */
public class MavenSettingsTransformer {

	private static AbstractUIProcessHandler mHandler;
	private static AutomatedInstallData idata;

	private static final String NAMESPACE = "xmlns:jbossas-installer";
	private static final String SPACE_ANGLE_CLOSE = "\\s*>";
	private static final String ANGLE_CLOSE = ">";
	private static final String EMPTY_STRING = "";
	private static final String NEW_LINE = "\n";
	private static String JBOSS_6 = "jboss6";
	private static String JBOSS_IP = "jboss-ip-repository";
	private static String REDHAT_TECH = "redhat-techpreview-all-repository";


    //XML TAGS
    private static final String ACTIVE_PROFILES = "activeProfiles";
    private static final String ACTIVE_PROFILE = "activeProfile";
    private static final String PROFILE = "profile";
    private static final String PROFILES = "profiles";
    private static final String REPOSITORIES = "repositories";
    private static final String REPOSITORY = "repository";
    private static final String PLUGIN_REPOSITORIES = "pluginRepositories";
    private static final String PLUGIN_REPOSITORY = "pluginRepository";
    private static final String ID = "id";
    private static final String URL = "url";
    private static final String SETTINGS = "settings";
    private static final String NAME = "name";
    private static final String LAYOUT = "layout";
    private static final String RELEASES = "releases";
    private static final String UPDATE_POLICY = "updatePolicy";
    private static final String SNAPSHOTS = "snapshots";
    private static final String ENABLED = "enabled";
    private static final String LOCAL_REPOSTIROY = "localRepository";
	private static final String REGEX_NAMESPACE = NAMESPACE + "=\".*\"";

	public static void run(AbstractUIProcessHandler handler, String[] args) throws Exception {
		mHandler = handler;
		idata = AutomatedInstallData.getInstance(); 
		String settingsFile = args[0];
		String mjrVersion = args[1];
		String installer = args[2];

		File test = new File(settingsFile);
		if (!test.exists()) // create a barebones settings.xml if the given
							// location doesn't exist
		{
			createDefaultSettingsXml(settingsFile);
		} else {
            // back it up!
            FileUtils.copyFile(test, new File(test.getPath()+".jboss_backup"));
			//makeBackup(settingsFile);
		}

		// replace the xsl functions with this monolith of a method
		readAndModifySettingsXml(settingsFile, installer);
	}

	/**
	 * Reads and modifies the settings XML read from the fileName, which is a
	 * path
	 */
	private static void readAndModifySettingsXml(String fileName,
			String installer) {
		String idStr = JBOSS_6;

		int status = 0;
		File settingsFile = new File(fileName);

		try 
		{
			DocumentBuilderFactory dbFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder builder = dbFactory.newDocumentBuilder();
			Document doc = builder.parse(settingsFile);

            ArrayList<Map<String, String>> profileData = new ArrayList<Map<String, String>>();
            ArrayList<String> existingIds = new ArrayList<String>();
            ArrayList<String> urls = new ArrayList<String>();

            if (installer.equals("eap")) {
                urls.add(idata.getVariable("MAVEN_REPO_PATH"));//jboss6
                profileData.add(genMap(
                        JBOSS_6, "jboss6-repository", "jboss6-plugin-repository", "JBoss 6 Maven Repository",
                        "JBoss 6 Maven Plugin Repository", idata.getVariable("MAVEN_REPO_PATH"), "never", "default"));
            } else  {
                urls.add("http://maven.repository.redhat.com/techpreview/all/");
                profileData.add(genMap(
                        REDHAT_TECH, REDHAT_TECH, REDHAT_TECH, "Red Hat Tech Preview repository (all)",
                        "Red Hat Tech Preview repository (all)", "http://maven.repository.redhat.com/techpreview/all/", "never", "default"));
            }

            urls = findMissingUrls(doc, urls); // Find the profile required to add based on url

            NodeList nodeList = doc.getElementsByTagName(ID);
            for (int i = 0; i < nodeList.getLength(); i++) {
                Element e = (Element) nodeList.item(i);
                existingIds.add(e.getTextContent());
            }

            Element root =  (Element) doc.getElementsByTagName(SETTINGS).item(0);
            Element profiles = (Element) doc.getElementsByTagName(PROFILES).item(0);
            Element actives = (Element) doc.getElementsByTagName(ACTIVE_PROFILES).item(0);

            if (profiles == null) {
                profiles = (Element) doc.createElement(PROFILES);
                root.appendChild(profiles);
            }
            if (actives  == null) {

                actives  = (Element) doc.createElement(ACTIVE_PROFILES);
                root.appendChild(actives);
            }

            for (Map<String, String> entry : profileData){
                if (!urls.contains(entry.get("url"))) continue; //If it is a missing url add it
                if (existingIds.contains(entry.get("profileId")))     // Use a unique name if the profile name already exists
                    entry.put("profileId", entry.get("profileId") + "-" + System.currentTimeMillis());


                Element newProfile = generateProfile(
                        doc,
                        entry.get("profileId"),
                        entry.get("repoId"),
                        entry.get("pluginId"),
                        entry.get("repoName"),
                        entry.get("pluginName"),
                        entry.get("url"),
                        entry.get("updatePolicy"),
                        entry.get("layout"));
                profiles.appendChild(newProfile);
                Element newActive = doc.createElement("activeProfile");
                newActive.setTextContent(entry.get("profileId"));
                actives.appendChild(newActive);
            }

            writeToFile(doc, settingsFile);


		} catch (Exception e) {
			e.printStackTrace();
			status = 1;
		}

	}

	private static Element generateProfile(Document doc, String profileID,
			String respositoryID, String pluginID, String repositoryNAME,
			String pluginNAME, String repositoryURL, String updatePolicy,
			String layout) {

		Element newProfile = doc.createElement(PROFILE);
		Element id = doc.createElement(ID);
		id.setTextContent(profileID);

		Element repos = doc.createElement(REPOSITORIES);
		Element repo = doc.createElement(REPOSITORY);
		Element repoId = doc.createElement(ID);
		repoId.setTextContent(respositoryID);
		Element repoName = doc.createElement(NAME);
		repoName.setTextContent(repositoryNAME);
		Element repoUrl = doc.createElement(URL);
		repoUrl.setTextContent(repositoryURL);
		Element repoLayout = doc.createElement(LAYOUT);
		repoLayout.setTextContent(layout);

		Element repoReleases = doc.createElement(RELEASES);
		Element repoRelEnabled = doc.createElement(ENABLED);
		repoRelEnabled.setTextContent("true");
		Element releasePolicy = doc.createElement(UPDATE_POLICY);
		releasePolicy.setTextContent(updatePolicy);

		Element repoSnapshots = doc.createElement(SNAPSHOTS);
		Element repoSnapEnabled = doc.createElement(ENABLED);
		repoSnapEnabled.setTextContent("false");
		Element snapshotPolicy = doc.createElement(UPDATE_POLICY);
		snapshotPolicy.setTextContent(updatePolicy);

		repoSnapshots.appendChild(repoSnapEnabled);
		repoSnapshots.appendChild(snapshotPolicy);

		repoReleases.appendChild(repoRelEnabled);
		repoReleases.appendChild(releasePolicy);

		repo.appendChild(repoId);
		repo.appendChild(repoName);
		repo.appendChild(repoUrl);
		repo.appendChild(repoLayout);
		repo.appendChild(repoReleases);
		repo.appendChild(repoSnapshots);
		// append repo to repos element
		repos.appendChild(repo);
		// repositories element done

		Element pluginRepos = doc.createElement(PLUGIN_REPOSITORIES);
		// plugin repo
		Element pluginRepo = doc.createElement(PLUGIN_REPOSITORY);
		Element pluginRepoId = doc.createElement(ID);
		pluginRepoId.setTextContent(pluginID);
		Element pluginRepoName = doc.createElement(NAME);
		pluginRepoName.setTextContent(pluginNAME);
		Element pluginRepoUrl = doc.createElement(URL);
		pluginRepoUrl.setTextContent(repositoryURL);

		Element pluginLayout = doc.createElement(LAYOUT);
		pluginLayout.setTextContent(layout);

		Element pluginRepoReleases = doc.createElement(RELEASES);
		Element pluginRepoRelEnabled = doc.createElement(ENABLED);
		pluginRepoRelEnabled.setTextContent("true");

		Element pluginReleasePolicy = doc.createElement(UPDATE_POLICY);
		pluginReleasePolicy.setTextContent(updatePolicy);

		Element pluginRepoSnapshots = doc.createElement(SNAPSHOTS);
		Element pluginRepoSnapEnabled = doc.createElement(ENABLED);
		pluginRepoSnapEnabled.setTextContent("false");
		Element pluginSnapshotPolicy = doc.createElement(UPDATE_POLICY);
		pluginSnapshotPolicy.setTextContent(updatePolicy);

		// organize everything

		pluginRepoSnapshots.appendChild(pluginRepoSnapEnabled);
		pluginRepoSnapshots.appendChild(pluginSnapshotPolicy); // policied being
																// added

		pluginRepoReleases.appendChild(pluginRepoRelEnabled);
		pluginRepoReleases.appendChild(pluginReleasePolicy); // Policies being
																// added

		pluginRepo.appendChild(pluginRepoId);
		pluginRepo.appendChild(pluginRepoName);
		pluginRepo.appendChild(pluginRepoUrl);
		pluginRepo.appendChild(pluginLayout);
		pluginRepo.appendChild(pluginRepoReleases);
		pluginRepo.appendChild(pluginRepoSnapshots);
		pluginRepos.appendChild(pluginRepo);

		// construction!
		newProfile.appendChild(id);
		newProfile.appendChild(repos);
		newProfile.appendChild(pluginRepos);

		ProcessPanelHelper.printToPanel(mHandler, "Profile " + profileID
				+ " has been created", false);

		return newProfile;
	}

	/*
	 * Makes a backup of the File located at settingsPath. The backup will be in
	 * the same directory with the extension ".jboss_backup" added on to it.
	 */

	private static void makeBackup(String settingsPath) throws Exception {
        File settings = new File(settingsPath);
		File backup = new File(settings.getPath() + ".jboss_backup");
		InputStream in = new FileInputStream(settings);
		OutputStream out = new FileOutputStream(backup);

		byte[] buffer = new byte[1024];
		int len;
		while ((len = in.read(buffer)) > 0) {
			out.write(buffer, 0, len);
		}

		in.close();
		out.close();
	}

	/**
	 * Creates a Default settings xml. 
	 * Only used if the provided location is non-existent
	 */
	private static void createDefaultSettingsXml(String file) {
		File defaultSettings = new File(file);
		defaultSettings.getParentFile().mkdirs();
		int status = 0;
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root settings element
			Document doc = docBuilder.newDocument();
			Element root = doc.createElement(SETTINGS);
			Attr xmlns = doc.createAttribute("xmlns");
			xmlns.setValue("http://maven.apache.org/SETTINGS/1.0.0");
			Attr xmlnsXsi = doc.createAttribute("xmlns:xsi");
			xmlnsXsi.setValue("http://www.w3.org/2001/XMLSchema-instance");
			Attr xsiLoc = doc.createAttribute("xsi:schemaLocation");
			xsiLoc.setValue("http://maven.apache.org/SETTINGS/1.0.0");
            Attr xsdLoc = doc.createAttribute("xsi:schemaLocation");
            xsdLoc.setValue("http://maven.apache.org/xsd/settings-1.0.0.xsd");
			root.setAttributeNode(xmlns);
			root.setAttributeNode(xmlnsXsi);
			root.setAttributeNode(xsiLoc);
            root.setAttributeNode(xsdLoc);
			doc.appendChild(root);

			// child localRepository element
			Element localRepo = doc.createElement(LOCAL_REPOSTIROY);
			root.appendChild(localRepo);


			// child profiles
			Element profiles = doc.createElement(PROFILES);
			root.appendChild(profiles);

			// child active profiles
			Element activeProfiles = doc.createElement(ACTIVE_PROFILES);
			root.appendChild(activeProfiles);

			// done construction; now write the file
			writeToFile(doc, defaultSettings);

		} catch (Exception e) {
			e.printStackTrace();
			status = 1;
		}

		if (status != 0) 
		{
			ProcessPanelHelper.printToPanel(mHandler,
					"Maven Settings: "  + idata.langpack.getString("MavenRepoCheckPanel.xslt.default.failure"),
					true);
		} 
		else 
		{
			ProcessPanelHelper.printToPanel(mHandler,
					"Maven Settings: "
					+ idata.langpack.getString("MavenRepoCheckPanel.xslt.default.success")
					+ file,
					false);
		}
	}

	/**
	 * Writes a DOM document to a File
	 */
	private static void writeToFile(Document doc, File file) {
		BufferedWriter writeOut = null;
		try {
			TransformerFactory tFactory = TransformerFactory.newInstance();
			tFactory.setAttribute("indent-number", 4);
			Transformer trans = tFactory.newTransformer();
			trans.setOutputProperty(OutputKeys.INDENT, "yes");
			DOMSource source = new DOMSource(doc);

			StreamResult result = new StreamResult(new StringWriter());
			trans.transform(source, result);

			String outputString = result.getWriter().toString();

			writeOut = new BufferedWriter(new FileWriter(file));
			writeOut.write(outputString);
			writeOut.close();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

    /**
     *  Requires the number of arguements in the keys array
     * @param data Input the number of required fields based on your keys array
     * @return Hashmap of your data
     */
    private static HashMap<String, String> genMap(String... data){
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String [] keys =  {"profileId", "repoId", "pluginId", "repoName", "pluginName", "url", "updatePolicy", "layout"};
        if (data.length != keys.length) throw new InputMismatchException("Number of arguments don't match the length of the key array");
        //System.out.println("KEY LENGTH IS: " + keys.length);
        for (int i = 0; i < keys.length; i++){
            dataMap.put(keys[i], data[i]);
        }
        return dataMap;
    }

    /** Description
     * @param doc  Your xml document
     * @param urls Urls to look for
     * @return List of urls that are missing from the settings.xml file
     */
    private static ArrayList<String> findMissingUrls(Document doc, ArrayList<String> urls) {
        //Get all active profiles
        ArrayList<String> activeProfiles = new ArrayList<String>();
        NodeList activeProfileList = doc.getElementsByTagName(ACTIVE_PROFILES);
        for (int i = 0; i < activeProfileList.getLength(); i++) {
            Element p = (Element) activeProfileList.item(i);
            NodeList activeList = p.getElementsByTagName(ACTIVE_PROFILE);
            for (int j = 0; j < activeList.getLength(); j++) {
                Element a = (Element) activeList.item(j);
                activeProfiles.add(a.getTextContent());
            }
        }

        //Get all profiles
        NodeList profileList = doc.getElementsByTagName(PROFILE);
        for (int i = 0; i < profileList.getLength(); i++) {
            Element p = (Element) profileList.item(i);
            String profile = p.getElementsByTagName(ID).item(0).getTextContent();

            //Save the repo url if its a url you are looking for into url
            String url = "";
            //NodeList repoList = ((Element) p.getElementsByTagName(REPOSITORIES).item(0)).getElementsByTagName(REPOSITORY);
            NodeList reposList = p.getElementsByTagName(REPOSITORIES);
            Element repoElement = (Element)reposList.item(0);
            NodeList repoList = (repoElement != null) ? repoElement.getElementsByTagName(REPOSITORY) : null;
            if (repoList != null) {
            for (int j = 0; j < repoList.getLength(); j++) {
                Element repoElem = (Element) repoList.item(j);
                String repo = repoElem.getElementsByTagName(URL).item(0).getTextContent();
                if(urls.contains(repo)) {
                    url = repo;
                    }
                }
            }

            //If the plugin repository contains the same url of interest remove url of interest from the urls List
            // It's possible for p.getElementsByTagName(...) to return null, so we can't immediately do .item(0) on it
            //NodeList pluginList = ((Element) p.getElementsByTagName(PLUGIN_REPOSITORIES).item(0)).getElementsByTagName(PLUGIN_REPOSITORY);
            NodeList pluginRepoList = p.getElementsByTagName(PLUGIN_REPOSITORIES);
            Element pluginRepoElement = ((Element)pluginRepoList.item(0));
            NodeList pluginList = (pluginRepoElement != null) ? pluginRepoElement.getElementsByTagName(PLUGIN_REPOSITORY) : null;
            if (pluginList != null) {
            for (int j = 0; j < pluginList.getLength(); j++) {
                Element pluginElem = (Element) pluginList.item(j);
                String pluginRepo = pluginElem.getElementsByTagName(URL).item(0).getTextContent();
                if(url.equals(pluginRepo) && activeProfiles.contains(profile)) {
                    urls.remove(url);
                    }
                }
            }
            url ="";
        }
        return urls;
    }
}
