package com.redhat.installer.postinstall;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.xml.sax.SAXException;

import com.izforge.izpack.util.AbstractUIProcessHandler;

/**
 * This process will perform an XML->XML transformation on a set of xml docs. The
 * transformation is based on the specs file given in as the first argument. The set
 * of xml docs to transform are the remaining arguments.
 * @author fcanas
 *
 */
public class XslTransformer {

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        String inputXsl = args[0]; // the XSLT spec document.

        try {
        	transform(inputXsl,args);

        } catch (ParserConfigurationException e) {
            // Debug statements here
            System.err.println(e.getStackTrace());
        } catch (SAXException e) {
            System.err.println(e.getStackTrace());
        } catch (TransformerException e) {
            System.err.println(e.getStackTrace());
        } catch (IOException e) {
            System.err.println(e.getStackTrace());
        }
    }

    private static void transform(String infilepath, String ... files)
            throws ParserConfigurationException, SAXException, TransformerException, IOException {
        Source xslt = new StreamSource(new File(infilepath));
        ArrayList<File> configFiles = new ArrayList<File>();
        
        // start at 1 because the way the args are currently arranged, no harm no foul
        for (int i = 1; i < files.length; i++){
        	configFiles.add(new File(files[i]));
        }
        
        TransformerFactory tFactory = TransformerFactory.newInstance();
        tFactory.setAttribute("indent-number", 4); 
        Transformer trans = tFactory.newTransformer(xslt);
        trans.setOutputProperty(OutputKeys.INDENT, "yes"); 
        

        // Write to file from a String to preserve indentation
        for (File configFile : configFiles){
        	StreamResult result = new StreamResult(new StringWriter());
        	trans.transform(new StreamSource(configFile), result);
            String outputString = result.getWriter().toString();
            BufferedWriter writeOut = null;
            try {
                writeOut = new BufferedWriter(new FileWriter(configFile));
                writeOut.write(outputString);
            } finally {
                if (writeOut != null) {
                    writeOut.close();
                }
            }
        }
    }
}
