package com.redhat.installer.postinstall;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.OsVersion;

/**
 * @author dcheung@redhat.com, dmondega@redhat.com, thauser@redhat.com,
 *         aszczucz@redhat.com, jtripath@redhat.com
 */
public class ProcessPanelHelper {
	private static final String STANDALONE_CONFIG = "standalone-config";
	private static final String SERVER_SCRIPT  = "server-script";
	private static final String POSTINSTALL_SCRIPT = "postinstall-script";
	private static final String TIMEOUT  = "timeout";
	private static final String ATTEMPTS = "attempts";
	private static final String UNZIP_NATIVES = "unzip-natives";
    private static final String DEFAULT_TIMEOUT = "1";
    private static final String DEFAULT_ATTEMPTS = "20";
	private static final String DEFAULT_URL      = "http://localhost:";
	private static final String URL_EXTENSION		 = "url-ext";
	private static final String URL_RESPONSE		 = "url-resp";
//	private static final String HTTP_VARIABLE    = "standalone.http.with-offset";
    public static final String SERVER_UP = "server_up";
    public static final String SERVER_MODE = "server_mode";
	private static final String LAUNCH_BROWSER = "launch-browser";

    // Possible server codes we read from output:
    public static final String CODE_START_OK = "JBAS015874";
    public static final String CODE_START_ERROR = "JBAS015875";
    public static final String CODE_START_OK_FULL_HA = "JBAS015888";
    public static final String CODE_STOP_OK = "JBAS015950";
    private static String realm;
    private static String path;

	private static AbstractUIProcessHandler mHandler;

	public static boolean serverIsUp;

	public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
		String startingServerString = idata.langpack.getString("postinstall.processpanel.startingServer");
		String checkingServerString = idata.langpack.getString("postinstall.processpanel.checkingServer");
		String serverNotStartedString = idata.langpack.getString("postinstall.processpanel.serverNotStarted");
		String serverStartedString = idata.langpack.getString("postinstall.processpanel.serverStarted");
        String browserLaunch = idata.langpack
                .getString("postinstall.processpanel.browserLaunch");
        String browserLaunchAbort = idata.langpack
                .getString("postinstall.processpanel.browserLaunchAbort");

	    ScriptLauncher serverScript;
		LaunchBrowser br;
		String serverLocation   = null;
		String link             = null;
		int [] urlCodes;
		mHandler = handler;
		int timeToSleep;
		int attempts;
		int attemptLimit;

/*		if (args.length > 4) {
			mHandler.logOutput("Error: Usage:", true);
			mHandler.logOutput("\t java ProcessPanelHelper \\ ", true);
			mHandler.logOutput("\t --server-script=path/to/script \\ ", true);
			mHandler.logOutput("\t --timeout=5 \t [Default:5] \\ ", true);
			mHandler.logOutput("\t --attempts=10 \t [Default:10]", true);
			mHandler.logOutput("", true);
			mHandler.logOutput("If server-script is not provided, then the program assumes that you don't want to start the server", true);
			mHandler.logOutput("Note that you need to provide a value for the link option in order to launch the browser", true);
			return;
		}*/

		ArgumentParser parser = new ArgumentParser();
		parser.parse(args);

		timeToSleep  = Integer.parseInt(parser.getProperty(TIMEOUT, DEFAULT_TIMEOUT));
		attemptLimit = Integer.parseInt(parser.getProperty(ATTEMPTS, DEFAULT_ATTEMPTS));


        if (parser.hasProperty(UNZIP_NATIVES)) {
            final String installPath = idata.getInstallPath();

            // Check for a native unzip utility (available on *nix usually)
            boolean hasUnzip;
            try {
                Runtime.getRuntime().exec("unzip");
                hasUnzip = true;
            } catch (Exception e) {
                hasUnzip = false;
            }

            // Check for link utility (available on *nix almost always)
            boolean hasLink;
            try {
                Runtime.getRuntime().exec("ln");
                hasLink = true;
            } catch (Exception e) {
                hasLink = false;
            }

            // Filter for files with a .zip extension
            FilenameFilter zipFilter = new FilenameFilter() {
                public boolean accept( File dir, String name )
                {
                    return name.endsWith( ".zip" );
                }
            };

            // For saving the combined lines of the SHA256SUM files from multiple zips.
            List<String> sha256sums = new ArrayList<String>();

            // Process zips in izpack install path
            File[] list = new File(installPath).listFiles(zipFilter);
            for (File sourceZipPath : list) {

                // Use unzip if available, except on Solaris, as its unzip is buggy
                if (hasUnzip && !OsVersion.IS_SUNOS) {
                        try
                        {
                            Process p = new ProcessBuilder("unzip", "-o", sourceZipPath.toString(), "-d", installPath).start();
                            if (p.waitFor() != 0) {
                                throw new RuntimeException("Native unzip utility exited abnormally for " + sourceZipPath);
                            }
                        }
                        catch ( IOException e )
                        {
                            throw new RuntimeException("Couldn't exec native unzip utility", e);
                        }
                        catch ( InterruptedException e )
                        {
                            return;
                        }

                        if (!sourceZipPath.delete()) {
                            System.err.println("Couldn't delete temporary zip " + sourceZipPath);
                        }

                        sha256sums.addAll(getSHA256sums());

                // Use Java's unzip functionality, plus symlink processing
                } else {
                    ZipFile zipFile = null;
                    try {
                        zipFile = new ZipFile(sourceZipPath);

                        // Extract all files
                        Enumeration<? extends ZipEntry> entries = zipFile.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();

                            // Create directory tree leading to the destination path
                            File destinationPath = new File(installPath, entry.getName());
                            destinationPath.getParentFile().mkdirs();

                            // Entry is a directory
                            if (entry.isDirectory()) {
                                // This is required to handle any empty directories in the zip
                                // Create the last directory in destinationPath
                                destinationPath.mkdir();

                            // Entry is an actual file
                            } else {
                                // Copy entire stream for the entry to disk
                                FileOutputStream fos = null;
                                FileChannel outputChannel = null;
                                try {
                                    fos = new FileOutputStream(destinationPath);
                                    outputChannel = fos.getChannel();

                                    ReadableByteChannel inputChannel = Channels.newChannel(zipFile.getInputStream(entry));

                                    outputChannel.transferFrom(inputChannel, 0L, Long.MAX_VALUE);
                                } catch (IOException e) {
                                    throw new RuntimeException("Can't write destination file " + destinationPath, e);
                                } finally {
                                    if (fos != null) {
                                        try {
                                            fos.close();
                                        } catch (IOException e) {
                                        }
                                    }
                                    if (outputChannel != null) {
                                        try {
                                            outputChannel.close();
                                        } catch (IOException e) {
                                        }
                                    }
                                    // Closing the zip entry's input stream will close the whole zip file, so don't close it here.
                                }

                                // Process symlinks if applicable (Method is STORED, and contents are a single line, and are a path)
                                if (hasLink && entry.getMethod() == ZipEntry.STORED) {
                                    // Get just one line of text in the file, and check there is only one line of text in the file.
                                    BufferedReader reader = null;
                                    String firstLine;
                                    String secondLine;
                                    try {
                                        reader = new BufferedReader(new FileReader(destinationPath));
                                        firstLine = reader.readLine();
                                        secondLine = reader.readLine();
                                    } catch ( FileNotFoundException e ) {
                                        throw new RuntimeException("File written from zip does not exist " + destinationPath, e);
                                    } catch ( IOException e ) {
                                        throw new RuntimeException("File written from zip cannot be read " + destinationPath, e);
                                    } finally {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            } catch (IOException e) {
                                            }
                                        }
                                    }

                                    // Check if there is only one line
                                    if (secondLine == null) {
                                        // Check if the first line is a valid path
                                        File symlinkTarget = new File(firstLine);
                                        boolean validPath;
                                        try {
                                            symlinkTarget.getCanonicalPath();
                                            validPath = true;
                                        }
                                        catch (IOException e) {
                                            validPath = false;
                                        }

                                        if (validPath) {
                                            // Create a symlink to replace the one-line file
                                            try {
                                                Process p = new ProcessBuilder("ln", "-s", "-f", symlinkTarget.toString(), destinationPath.toString()).start();
                                                if (p.waitFor() != 0) {
                                                    throw new RuntimeException("Link utility exited abnormally when converting " + destinationPath);
                                                }
                                            }
                                            catch ( IOException e )
                                            {
                                                throw new RuntimeException("Couldn't exec link utility", e);
                                            } catch (InterruptedException e) {
                                                return;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        sha256sums.addAll(getSHA256sums());
                    } catch (IOException e) {
                        throw new RuntimeException("Can't extract zip file " + sourceZipPath, e);
                    } finally {
                        try {
                            if (zipFile != null) {
                                zipFile.close();
                            }
                        } catch (IOException e) {
                        }
                        sourceZipPath.delete();
                    }
                }
            }
            if (!sha256sums.isEmpty()){
            	writeSHA256sums(sha256sums);
            }

            handler.logOutput(idata.langpack.getString("postinstall.processpanel.unpacking.complete"), false);
        }

        /**
         * Launch browser job goes here.
         */
        if (parser.hasProperty(LAUNCH_BROWSER)) {
            link = ServerManager.getURL()
                    + ServerManager.getManagementHttpPort();
            if (ServerManager.isServerUp()) {
                handler.logOutput(browserLaunch, false);
                br = new LaunchBrowser();
                br.exec(link);
            } else {
                handler.logOutput(browserLaunchAbort, false);
            }
        }

	}



    /**
     * Helper method that writes all of the gathered SHA256SUMs into a single file. Delimited by a simple line feed
     * @param sums
     * @throws Exception
     */
    private static void writeSHA256sums(List<String> sums) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();

		File sumFile = new File(idata.getInstallPath() + "/" + idata.getVariable("INSTALL_SUBPATH") + "/SHA256SUM");

        // Current file is that of the latest zip, we need to replace it
        sumFile.delete();

        BufferedWriter br = null;
        try {
            br = new BufferedWriter(new FileWriter(sumFile));
            for (String sum : sums) {
                // Newline is constant (not decided by OS) so as to pass QE file diff checks
                br.write(sum + "\n");
            }
        } catch (IOException e) {
            throw new RuntimeException("Cannot write master zip SHA256SUM file to " + sumFile, e);
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                }
            }
        }
    }

    /**
     * Helper method used during native unzipping to amalgamate the SHA256SUM files that the zips contain.
     * If this is not done, the zips will overwrite eachother, and we'll be left with only the file contents of the 
     * one that wins that race.
     *
     * @return List of SHA256SUM file lines
     */
    private static List<String> getSHA256sums() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();

        File sumFile = new File(idata.getInstallPath()+"/"+idata.getVariable("INSTALL_SUBPATH")+"/SHA256SUM");

        List<String> retval = new ArrayList<String>();

        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(sumFile));
            String line;
            while ((line = br.readLine()) != null) {
                retval.add(line);
            }
        } catch ( FileNotFoundException e ) {
        } catch ( IOException e ) {
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                }
            }
        }

        return retval;
    }

	private static class LaunchBrowser {

		private Desktop desktop;

		/*
        private boolean createDesktopObject() {
            if (Desktop.isDesktopSupported()) {
                desktop = Desktop.getDesktop();
                return true;
            } else {
                mHandler.logOutput("Cannot Open Browser!", true);
                return false;
            }
        }

        private void openURL(final String url) {
            try {
                desktop.browse(new URI(url));
            } catch (IOException e) {
                mHandler.logOutput("Cannot find default browser!", true);
            } catch (Exception f) {
                f.printStackTrace();
            }
        }
		 */

		// Entry Point
		private void exec(final String url) {
			try {
				openURI(new URI(url));
			} catch (URISyntaxException e) {
				e.printStackTrace();
			}
		}

		private void openURI(URI uri) {
			if (Desktop.isDesktopSupported()) {
				Desktop desktop = Desktop.getDesktop();
				if (desktop.isSupported(java.awt.Desktop.Action.BROWSE)) {
					try {
						desktop.browse(uri);
						mHandler.logOutput("Browser Launched", false);
					} catch (IOException e) {
						if (! (openFallback(uri)) ) {
							/*JOptionPane.showMessageDialog(null,
                                "Failed to launch the link, " +
                                "your platform's BROWSE action doesn't support the URI",
                                "Cannot Launch Link",JOptionPane.WARNING_MESSAGE);*/
							mHandler.logOutput("Cannot Open Browser! - BROWSE action does not support the URI", true);
						}
					}
				} else {
					if (! (openFallback(uri)) ) {
						/*JOptionPane.showMessageDialog(null,
                            "Failed to launch the link, " +
                            "your platform doesn't support the BROWSE action.",
                            "Cannot Launch Link",JOptionPane.WARNING_MESSAGE);*/
						mHandler.logOutput("Cannot Open Browser! - BROWSE action not supported", true);
					}
				}
			} else {
				if (! (openFallback(uri)) ) {
					/*JOptionPane.showMessageDialog(null,
                        "Failed to launch the link, " +
                        "your platform doesn't support the Desktop class.",
                        "Cannot Launch Link",JOptionPane.WARNING_MESSAGE);*/
					mHandler.logOutput("Cannot Open Browser! - Desktop not supported", true);
				}
			}
		}

		private static boolean openFallback(URI uri) {
			// Attempt to use non-portable ways of launching the URI.
			// Return true on success, otherwise false.

			String os       = System.getProperty("os.name");
			Runtime runtime = Runtime.getRuntime();
			String url      = uri.toString();

			try {
				// Windows
				if (os.startsWith("Windows")) {
					runtime.exec("rundll32 url.dll,FileProtocolHandler " + url);
					mHandler.logOutput("Browser Launched via fallback Windows-specific call", false);
					// Mac OS
				} else if (os.startsWith("Mac OS")) {
					Class.forName("com.apple.eio.FileManager")
					.getDeclaredMethod("openURL", new Class[] {String.class})
					.invoke(null, new Object[] {url});
					mHandler.logOutput("Browser Launched via fallback Mac OS-specific call", false);
					// Otherwise Assume [LU]nix
				} else {
					String[] browsers = {"firefox", "opera", "konqueror",
							"epiphany", "mozilla", "netscape",
							"conkeror", "midori", "kazehakase"};
					String browser    = null;

					for (String b : browsers) {
						if (browser == null &&
								Runtime.getRuntime().exec(new String[]{"which", b})
								.getInputStream().read() != -1) {

							runtime.exec(new String[] {browser = b, url});
							mHandler.logOutput("Browser Launched via fallback Linux/Unix call", false);
						}
					}
					if (browser == null) {
						// No browser found
						// Last-ditch attempt with xdg-open
						runtime.exec(new String[] {"xdg-open", url});
						mHandler.logOutput("Browser Launched via fallback xdg-open call", false);
					}
				}
			} catch(Exception e) {
                /*JOptionPane.showMessageDialog(null,
                    "Failed to launch the link, " +
                    "exception occurred while attempting fallback.",
                    "Cannot Launch Link",JOptionPane.WARNING_MESSAGE);*/
                mHandler.logOutput("Cannot Open Browser! - Fallback Failed", true);
                return false;
            }
			return true;
		}
	}

    public static class ScriptLauncher {

		private ProcessBuilder builder;
		private Process p;
		private BufferedReader reader;
		private BufferedWriter writer;
		private static AbstractUIProcessHandler mHandler;
        private AutomatedInstallData idata;

		ScriptLauncher(String...command) {
			builder = new ProcessBuilder(command);
			adjustJbossHome(builder);
			mHandler = null;
        }

		/**
		 * This one takes an explicit handler for output.
		 * @param handler
		 * @param command
		 */
        ScriptLauncher(AbstractUIProcessHandler handler, String... command) {
            idata = AutomatedInstallData.getInstance();
			builder = new ProcessBuilder(command);
			adjustJbossHome(builder);
            printToPanel(handler,"JBOSS_HOME adjusted to: " + builder.environment().get("JBOSS_HOME"),false);
			mHandler = handler;
        }

		@SuppressWarnings("deprecation")
        public void runScript() {
			try {
				p       = builder.start();
				reader  = new BufferedReader (new InputStreamReader(p.getInputStream()));
				writer  = new BufferedWriter (new OutputStreamWriter(p.getOutputStream()));
				writer.newLine();
				writer.flush();
				Thread b = new Thread(new Runnable() {
					public void run() {
						try {
                            boolean foundCode = false;
                            boolean serverNotReady = true;
                            BufferedWriter log = new BufferedWriter(
                                    new OutputStreamWriter(
                                            new FileOutputStream(
                                                    idata.getInstallPath()
                                                            + File.separator
                                                            + idata.getVariable("installation.logfile"),
                                                    true)));
                            String line;
							int counter = 0;

							while((line = reader.readLine()) != null) {
                                // Check for readiness codes here
                                String code = ServerManager.extractCode(line);

                                if (!code.isEmpty() && !foundCode) {
                                    ServerManager.setServerCode(code);
                                    printToPanel(mHandler, String.format(idata.langpack.getString("ProcessPanelHelper.servercode.detected"),code), false);
                                    /*mHandler.logOutput(
                                            "[ Server code detected: " + code
                                                    + "]", false);*/
                                    serverNotReady = false;
                                    foundCode = true;
                                }
                                //Didn't want to conflict is original code detection
                                String endCode = ServerManager.extractEndCode(line);
                                if (!endCode.isEmpty()) {
                                    ServerManager.setServerDown();
                                    serverNotReady = false;
                                }
                                /**
                                 * if
                                 * (line.contains(ServerManager.CODE_START_OK))
                                 * { ServerManager
                                 * .setServerCode(ServerManager.CODE_START_OK);
                                 * serverNotReady = false; mHandler.logOutput(
                                 * "[ Server code detected: " +
                                 * ServerManager.CODE_START_OK + "]", false); }
                                 * else if (line
                                 * .contains(ServerManager.CODE_START_ERROR)) {
                                 * ServerManager .setServerCode(ServerManager.
                                 * CODE_START_ERROR); serverNotReady = false;
                                 * mHandler.logOutput(
                                 * "[ Server code detected: " +
                                 * ServerManager.CODE_START_ERROR + "]", false);
                                 * }
                                 **/

                                if (line.lastIndexOf('\033') > -1) {
                                    line = line.substring(
                                            line.lastIndexOf('\033'),
                                            line.length());
                                    line = line.substring(
                                            line.indexOf('m') + 1,
                                            line.length());
                                }

                                /**
                                 * Print to GUI/Console only until server is
                                 * ready, then stop outputting but continue
                                 * swallowing.
                                 **/
                                if (serverNotReady){
                                	if (idata.getVariable("installerMode").equals("GUI")){
                                		if (counter < 20){
                                			if (mHandler != null)
                                			mHandler.logOutput(line, false);
                                		}
                                		log.write(line);
                                		log.newLine();
                                		log.flush();
                                	} else{
                                		printToPanel(mHandler, line, false);
                                	}
                                }

                                /**
                                 * If in GUI mode, make sure the output is also
                                 * logged to file.
                                 */
 /*                               if (idata.getVariable("installerMode").equals(
                                        "GUI")) {
                                    log.write(line);
                                    log.newLine();
                                    log.flush();
                                }*/
                                counter++;
						}
							log.close();
						} catch (IOException e) {
						}
					}
				});
				b.setDaemon(true);
				b.start();
				b.join(5000);
				//don't stop swallowing
				//b.stop();
			} catch (IOException e) {
				e.printStackTrace();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	private static class LinkAlive {
        public static boolean isLinkAlive(String URLName) {
            /**
             * try { HttpURLConnection.setFollowRedirects(false);
             * HttpURLConnection con = (HttpURLConnection) new
             * URL(URLName).openConnection(); con.setRequestMethod("HEAD");
             * return (con.getResponseCode() == HttpURLConnection.HTTP_OK); }
             * catch (Exception e) { return false; }
             **/
            return isLinkAlive(URLName, new int[] { HttpURLConnection.HTTP_OK });

        }

        /**
         * 
         * @param URLName
         * @param goodcodes
         *            A list of integers. Each int is an expected HTTP Response
         *            code.
         * @return True if the http interface returned one of the goodcodes.
         *         False otherwise.
         */
        public static boolean isLinkAlive(String URLName, int[] goodcodes) {
            HttpURLConnection urlConn = null;

            try {
                URL url = new URL(URLName);
                urlConn = (HttpURLConnection) url.openConnection();
                urlConn.connect();

                // For debugging:
                /*
                System.out.println("Server Response Code: "
                        + urlConn.getResponseCode());*/

                /**
                 * Assume bad response until proven otherwise.
                 */
                boolean response = false;

                /**
                 * Check the actual response code against the list of desired
                 * HTTP response codes.
                 */
                for (int code : goodcodes) {
                    if (urlConn.getResponseCode() == code) return true;
                }

                return false;
            } catch (IOException e) {
                // System.err.println("Error creating HTTP connection");
                // e.printStackTrace();
                //
                // Maybe this shoudln't be here
                /*
               try {
                               HttpURLConnection.setFollowRedirects(false);
                               HttpURLConnection con = (HttpURLConnection) new URL(URLName).openConnection();
                               con.setRequestMethod("HEAD");
                               return (con.getResponseCode() == HttpURLConnection.HTTP_OK);
                       } catch (Exception e) {
                       */
                return false;
            }
        }
	}

	/**
	 * This method simply sets the given ProcessBuilder's environment variable JBOSS_HOME to the current installation. This resolves 
	 * https://bugzilla.redhat.com/show_bug.cgi?id=1017054
	 * TODO: is there a better place for this method?
	 * @param builder
	 */

	public static void adjustJbossHome(ProcessBuilder builder){
		Map<String,String> env = builder.environment();
		env.put("JBOSS_HOME", AutomatedInstallData.getInstance().getInstallPath()+File.separator+AutomatedInstallData.getInstance().getVariable("INSTALL_SUBPATH"));
	}

	/**
	 * Helper method to print text to the panel. This method will log the output to the logfile in an appropriate manner.
	 * @param handler
	 * @param message
	 */

	public static void printToPanel(AbstractUIProcessHandler handler, String message, boolean error) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
		BufferedWriter log;
        String ignoreMsg = "Press any key to continue";
		try {
			log = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(idata.getInstallPath() + File.separator + idata.getVariable("installation.logfile"), true)));
			if (!message.contains(ignoreMsg)){
			        handler.logOutput(message, error);
            }

			if (idata.getVariable("installerMode").equals("GUI")) {
				log.write(message);
				log.newLine();
				log.flush();
			}
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
