package com.redhat.installer.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;

/**
 * Action for bridging the two variables set by SocketBindingPanel
 * and writing the result into variable standalone.port-offset
 *
 * Should be registered to run after validation
 *
 * @author Alex Szczuczko <aszczucz@redhat.com>
 */
public class OffsetVariableBridgeAction implements PanelAction {

    /**
     * @param handler Note, as per spec., if there isn't a GUI, handler is null
     */
    public void executeAction(final AutomatedInstallData adata, AbstractUIHandler handler) {

        final String var_pD  = adata.getVariable("portDecision");
        final String var_pOT = adata.getVariable("portOffsetType");
        final String var_cPO = adata.getVariable("configurePortOffset");
        final int domainNativePort = 9999;
        final int domainHttpPort = 9990;

        Integer portOffsetValue = new Integer(0);

        //System.out.println("DEBUG - OVBA - START|"+var_cPO+"|"+var_pOT+"|"+portOffsetValue+"|"+var_pD);

        if (var_pD != null && var_pD.equals("assist")) {
            try {
                if (var_pOT.equals("1")) {
                    portOffsetValue = Integer.valueOf(var_pOT);
                } else if (var_pOT.equals("100")) {
                    portOffsetValue = Integer.valueOf(var_pOT);

                } else if (var_pOT.equals("specify")) {
                    // Expecting var_pOT equals 0, or var_pOT is null
                    if (! var_cPO.isEmpty() ) {
                        portOffsetValue = Integer.valueOf(var_cPO);
                    } else {
                        // var_cPO is null!
                        // Shouldn't get here
                        // May get here if value fails validation
                        //System.out.println("No port offset value when specific value selected.");
                    }
                } else {
                    // var_pOT is null!
                    // Shouldn't get here
                    //System.out.println("No port offset type selected.");
                }
            } catch (NumberFormatException e) {
                // The number should have passed validation already.
                // Conversion is performed to ensure that the values are at least integers.
                // Shouldn't get here
                //System.out.println("Port offset value not an integer");
            }
        } // otherwise pOV remains 0, since assisted isn't selected

        // If we got errors anywhere portOffsetValue remains at the default value 0
        adata.setVariable("domain.management-native", "${jboss.management.native.port:"+ (domainNativePort + portOffsetValue) + "}");
        adata.setVariable("domain.management-http", "${jboss.management.http.port:"+ (domainHttpPort + portOffsetValue) + "}");
        adata.setVariable("master.domain.port", "${jboss.domain.master.port:"+ (domainNativePort + portOffsetValue) + "}");
        adata.setVariable("standalone.port-offset", "${jboss.socket.binding.port-offset:"+portOffsetValue.toString()+"}");
        adata.setVariable("domain.port-offset", portOffsetValue.toString());

        //System.out.println("DEBUG - OVBA - END |"+var_cPO+"|"+var_pOT+"|"+portOffsetValue+"|"+var_pD);
    }

    /**
     * There shouldn't be any need for configuration, since this is a dedicated class
     * @param configuration null if no configuration block for the action
     */
    public void initialize(PanelActionConfiguration configuration) {
        //System.out.println("DEBUG - OVBA - INIT");
    }
}
