/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.workbench.common.widgets.decoratedgrid.client.widget.data;

/**
 * A coordinate
 */
public class Coordinate {

    private int    row;
    private int    col;
    private String displayString;

    public Coordinate() {
        this.row = 0;
        this.col = 0;
        this.displayString = "(R" + this.row + ",C" + this.col + ")";
    }

    public Coordinate( Coordinate c ) {
        this.row = c.row;
        this.col = c.col;
        this.displayString = "(R" + c.row + ",C" + c.col + ")";
    }

    public Coordinate( int row,
                       int col ) {
        this.row = row;
        this.col = col;
        this.displayString = "(R" + row + ",C" + col + ")";
    }

    public int getCol() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    @Override
    public boolean equals( Object o ) {
        if ( this == o ) {
            return true;
        }
        if ( !( o instanceof Coordinate ) ) {
            return false;
        }
        Coordinate c = (Coordinate) o;
        return c.col == col && c.row == row;
    }

    @Override
    public int hashCode() {
        int hash = row;
        hash = 31 * hash + col;
        return hash;
    }

    @Override
    public String toString() {
        return displayString;
    }

}
