/*
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.widgets.client.datamodel.testclasses;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

/**
 * Test class to check data-types are extracted correctly by ProjectDataModelOracleBuilder
 */
public class TestDataTypes {

    private String     fieldString;
    private Boolean    fieldBooleanObject;
    private boolean    fieldBooleanPrimitive;
    private Date       fieldDate;
    private BigDecimal fieldNumeric;
    private BigDecimal fieldBigDecimal;
    private BigInteger fieldBigInteger;
    private Byte       fieldByteObject;
    private Double     fieldDoubleObject;
    private Float      fieldFloatObject;
    private Integer    fieldIntegerObject;
    private Long       fieldLongObject;
    private Short      fieldShortObject;
    private byte       fieldBytePrimitive;
    private double     fieldDoublePrimitive;
    private float      fieldFloatPrimitive;
    private int        fieldIntegerPrimitive;
    private long       fieldLongPrimitive;
    private short      fieldShortPrimitive;

    public String getFieldString() {
        return fieldString;
    }

    public void setFieldString(String fieldString) {
        this.fieldString = fieldString;
    }

    public Boolean getFieldBooleanObject() {
        return fieldBooleanObject;
    }

    public void setFieldBooleanObject(Boolean fieldBooleanObject) {
        this.fieldBooleanObject = fieldBooleanObject;
    }

    public boolean isFieldBooleanPrimitive() {
        return fieldBooleanPrimitive;
    }

    public void setFieldBooleanPrimitive(boolean fieldBooleanPrimitive) {
        this.fieldBooleanPrimitive = fieldBooleanPrimitive;
    }

    public Date getFieldDate() {
        return fieldDate;
    }

    public void setFieldDate(Date fieldDate) {
        this.fieldDate = fieldDate;
    }

    public BigDecimal getFieldNumeric() {
        return fieldNumeric;
    }

    public void setFieldNumeric(BigDecimal fieldNumeric) {
        this.fieldNumeric = fieldNumeric;
    }

    public BigDecimal getFieldBigDecimal() {
        return fieldBigDecimal;
    }

    public void setFieldBigDecimal(BigDecimal fieldBigDecimal) {
        this.fieldBigDecimal = fieldBigDecimal;
    }

    public BigInteger getFieldBigInteger() {
        return fieldBigInteger;
    }

    public void setFieldBigInteger(BigInteger fieldBigInteger) {
        this.fieldBigInteger = fieldBigInteger;
    }

    public Byte getFieldByteObject() {
        return fieldByteObject;
    }

    public void setFieldByteObject(Byte fieldByteObject) {
        this.fieldByteObject = fieldByteObject;
    }

    public Double getFieldDoubleObject() {
        return fieldDoubleObject;
    }

    public void setFieldDoubleObject(Double fieldDoubleObject) {
        this.fieldDoubleObject = fieldDoubleObject;
    }

    public Float getFieldFloatObject() {
        return fieldFloatObject;
    }

    public void setFieldFloatObject(Float fieldFloatObject) {
        this.fieldFloatObject = fieldFloatObject;
    }

    public Integer getFieldIntegerObject() {
        return fieldIntegerObject;
    }

    public void setFieldIntegerObject(Integer fieldIntegerObject) {
        this.fieldIntegerObject = fieldIntegerObject;
    }

    public Long getFieldLongObject() {
        return fieldLongObject;
    }

    public void setFieldLongObject(Long fieldLongObject) {
        this.fieldLongObject = fieldLongObject;
    }

    public Short getFieldShortObject() {
        return fieldShortObject;
    }

    public void setFieldShortObject(Short fieldShortObject) {
        this.fieldShortObject = fieldShortObject;
    }

    public byte getFieldBytePrimitive() {
        return fieldBytePrimitive;
    }

    public void setFieldBytePrimitive(byte fieldBytePrimitive) {
        this.fieldBytePrimitive = fieldBytePrimitive;
    }

    public double getFieldDoublePrimitive() {
        return fieldDoublePrimitive;
    }

    public void setFieldDoublePrimitive(double fieldDoublePrimitive) {
        this.fieldDoublePrimitive = fieldDoublePrimitive;
    }

    public float getFieldFloatPrimitive() {
        return fieldFloatPrimitive;
    }

    public void setFieldFloatPrimitive(float fieldFloatPrimitive) {
        this.fieldFloatPrimitive = fieldFloatPrimitive;
    }

    public int getFieldIntegerPrimitive() {
        return fieldIntegerPrimitive;
    }

    public void setFieldIntegerPrimitive(int fieldIntegerPrimitive) {
        this.fieldIntegerPrimitive = fieldIntegerPrimitive;
    }

    public long getFieldLongPrimitive() {
        return fieldLongPrimitive;
    }

    public void setFieldLongPrimitive(long fieldLongPrimitive) {
        this.fieldLongPrimitive = fieldLongPrimitive;
    }

    public short getFieldShortPrimitive() {
        return fieldShortPrimitive;
    }

    public void setFieldShortPrimitive(short fieldShortPrimitive) {
        this.fieldShortPrimitive = fieldShortPrimitive;
    }

}
