/*
 * Copyright 2012 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.uberfire.client.mvp;

import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.PerspectiveDefinition;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.toolbar.ToolBar;

/**
 * Perspective Activity life-cycles
 */
public interface PerspectiveActivity
        extends
        ContextSensitiveActivity {

    void onStartup();

    void onStartup( final PlaceRequest place );

    void onClose();

    void onShutdown();

    PerspectiveDefinition getPerspective();

    String getIdentifier();

    boolean isDefault();

    Menus getMenus();

    ToolBar getToolBar();

}
