/*
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.benchmark.waltzdb;
//(literalize label id type name n1 n2 n3)
public class Label {
    private String id;
    private String type;
    private String name;
    private String n1;
    private String n2;
    private String n3;
    public Label() {
        super();
    }
    public Label(String id, String type, String name, String n1, String n2, String n3) {
        super();
        this.id = id;
        this.type = type;
        this.name = name;
        this.n1 = n1;
        this.n2 = n2;
        this.n3 = n3;
    }
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public String getN1() {
        return n1;
    }
    public void setN1(String n1) {
        this.n1 = n1;
    }
    public String getN2() {
        return n2;
    }
    public void setN2(String n2) {
        this.n2 = n2;
    }
    public String getN3() {
        return n3;
    }
    public void setN3(String n3) {
        this.n3 = n3;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getType() {
        return type;
    }
    public void setType(String type) {
        this.type = type;
    }

    public int hashCode() {
        final int PRIME = 31;
        int result = 1;
        result = PRIME * result + ((id == null) ? 0 : id.hashCode());
        result = PRIME * result + ((n1 == null) ? 0 : n1.hashCode());
        result = PRIME * result + ((n2 == null) ? 0 : n2.hashCode());
        result = PRIME * result + ((n3 == null) ? 0 : n3.hashCode());
        result = PRIME * result + ((name == null) ? 0 : name.hashCode());
        result = PRIME * result + ((type == null) ? 0 : type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        final Label other = (Label) obj;
        if (id == null) {
            if (other.id != null)
                return false;
        } else if (!id.equals(other.id))
            return false;
        if (n1 == null) {
            if (other.n1 != null)
                return false;
        } else if (!n1.equals(other.n1))
            return false;
        if (n2 == null) {
            if (other.n2 != null)
                return false;
        } else if (!n2.equals(other.n2))
            return false;
        if (n3 == null) {
            if (other.n3 != null)
                return false;
        } else if (!n3.equals(other.n3))
            return false;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (type == null) {
            if (other.type != null)
                return false;
        } else if (!type.equals(other.type))
            return false;
        return true;
    }
}
