/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jni;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class LibraryLoader {
    public static String getDefaultPlatformName() {
        String name = System.getProperty("os.name");
        String platform = "unknown";
        if (name.startsWith("Windows")) {
            platform = "windows";
        } else if (name.startsWith("Mac OS")) {
            platform = "macosx";
        } else if (name.endsWith("BSD")) {
            platform = "bsd";
        } else if (name.equals("Linux")) {
            platform = "linux2";
        } else if (name.equals("Solaris")) {
            platform = "solaris";
        } else if (name.equals("SunOS")) {
            platform = "solaris";
        } else if (name.equals("HP-UX")) {
            platform = "hpux";
        } else if (name.equals("AIX")) {
            platform = "aix";
        }
        if (platform.equals("solaris")) {
            String version = System.getProperty("os.version");
            platform = version.equals("5.10") ? "solaris10" : (version.equals("5.9") ? "solaris9" : "solaris11");
        }
        return platform;
    }

    public static String getDefaultPlatformCpu() {
        String arch = System.getProperty("os.arch");
        String cpu = arch.endsWith("86") ? "x86" : (arch.startsWith("PA_RISC") ? "parisc2" : (arch.startsWith("IA64") ? "i64" : (arch.equals("x86_64") ? "x64" : (arch.equals("amd64") ? "x64" : arch))));
        return cpu;
    }

    public static String getDefaultLibraryPath() {
        String name = LibraryLoader.getDefaultPlatformName();
        String arch = LibraryLoader.getDefaultPlatformCpu();
        return name + File.separator + arch;
    }

    public static String getDefaultMetaPath() {
        return "META-INF" + File.separator + "lib" + File.separator;
    }

    private LibraryLoader() {
    }

    protected static void load(String rootPath) throws SecurityException, IOException, UnsatisfiedLinkError {
        String metaPath;
        File meta;
        int count = 0;
        String name = LibraryLoader.getDefaultPlatformName();
        String path = LibraryLoader.getDefaultLibraryPath();
        Properties props = new Properties();
        File root = new File(rootPath);
        String basePath = root.getCanonicalPath().toString();
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separator;
        }
        if (!(meta = new File(metaPath = basePath + LibraryLoader.getDefaultMetaPath())).exists() && !(meta = new File(metaPath = basePath + "bin" + File.separator + LibraryLoader.getDefaultMetaPath())).exists()) {
            metaPath = basePath + "bin" + File.separator + "native";
        }
        try {
            InputStream is = LibraryLoader.class.getResourceAsStream("/org/apache/tomcat/jni/Library.properties");
            props.load(is);
            is.close();
            count = Integer.parseInt(props.getProperty(name + ".count"));
        }
        catch (Throwable t) {
            throw new UnsatisfiedLinkError("Can't use Library.properties");
        }
        for (int i = 0; i < count; ++i) {
            boolean full;
            block11: {
                String fullPath;
                boolean optional = false;
                full = false;
                String dlibName = props.getProperty(name + "." + i);
                if (dlibName.startsWith("?")) {
                    dlibName = dlibName.substring(1);
                    optional = true;
                }
                if (dlibName.startsWith("*")) {
                    dlibName = dlibName.substring(1);
                    full = true;
                }
                if (!(meta = new File(fullPath = metaPath + File.separator + path + File.separator + dlibName)).exists()) {
                    fullPath = metaPath + File.separator + dlibName;
                }
                try {
                    Runtime.getRuntime().load(fullPath);
                }
                catch (Throwable d) {
                    if (optional) break block11;
                    meta = new File(fullPath);
                    if (meta.exists()) {
                        throw new UnsatisfiedLinkError(" Error: " + d.getMessage() + " ");
                    }
                    throw new UnsatisfiedLinkError(" Can't find: " + fullPath + " ");
                }
            }
            if (full) break;
        }
    }
}

