/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.txtimer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.management.ObjectName;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.txtimer.GeneralPurposeDatabasePersistencePlugin;
import org.jboss.ejb.txtimer.TimedObjectId;
import org.jboss.ejb.txtimer.TimerHandleImpl;
import org.jboss.logging.Logger;

public class OracleDatabasePersistencePlugin
extends GeneralPurposeDatabasePersistencePlugin {
    private static Logger log = Logger.getLogger(OracleDatabasePersistencePlugin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTimer(String timerId, TimedObjectId timedObjectId, Date initialExpiration, long intervalDuration, Serializable info) throws SQLException {
        Connection con = null;
        PreparedStatement st = null;
        try {
            con = this.ds.getConnection();
            String sql = "insert into " + this.getTableName() + " " + "(" + this.getColumnTimerID() + "," + this.getColumnTargetID() + "," + this.getColumnInitialDate() + "," + this.getColumnTimerInterval() + "," + this.getColumnInstancePK() + "," + this.getColumnInfo() + "," + this.getColumnNextDate() + ") " + "values (?,?,?,?,?,?,?)";
            st = con.prepareStatement(sql);
            st.setString(1, timerId);
            st.setString(2, timedObjectId.toString());
            st.setTimestamp(3, new Timestamp(initialExpiration.getTime()));
            st.setLong(4, intervalDuration);
            byte[] pkArr = this.serialize(timedObjectId.getInstancePk());
            if (pkArr != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(pkArr);
                st.setBinaryStream(5, (InputStream)is, pkArr.length);
            } else {
                st.setBytes(5, null);
            }
            byte[] infoArr = this.serialize(info);
            if (infoArr != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(infoArr);
                st.setBinaryStream(6, (InputStream)is, infoArr.length);
            } else {
                st.setBytes(6, null);
            }
            st.setTimestamp(7, new Timestamp(initialExpiration.getTime()));
            int rows = st.executeUpdate();
            if (rows != 1) {
                log.error((Object)("Unable to insert timer for: " + timedObjectId));
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List selectTimers(ObjectName containerId) throws SQLException {
        ArrayList<TimerHandleImpl> arrayList;
        Connection con = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            con = this.ds.getConnection();
            ArrayList<TimerHandleImpl> list = new ArrayList<TimerHandleImpl>();
            st = con.createStatement();
            rs = st.executeQuery("select * from " + this.getTableName());
            while (rs.next()) {
                String timerId = rs.getString(this.getColumnTimerID());
                TimedObjectId targetId = TimedObjectId.parse(rs.getString(this.getColumnTargetID()));
                if (containerId != null && !containerId.equals(targetId.getContainerId())) continue;
                Timestamp initialDate = rs.getTimestamp(this.getColumnInitialDate());
                Timestamp nextTimeout = rs.getTimestamp(this.getColumnNextDate());
                long interval = rs.getLong(this.getColumnTimerInterval());
                InputStream isPk = rs.getBinaryStream(this.getColumnInstancePK());
                Serializable pKey = (Serializable)this.deserialize(isPk);
                Serializable info = null;
                try {
                    InputStream isInfo = rs.getBinaryStream(this.getColumnInfo());
                    info = (Serializable)this.deserialize(isInfo);
                }
                catch (Exception e) {
                    log.warn((Object)"Cannot deserialize custom info object", (Throwable)e);
                }
                targetId = new TimedObjectId(targetId.getContainerId(), pKey);
                TimerHandleImpl handle = new TimerHandleImpl(timerId, targetId, initialDate, nextTimeout, interval, info);
                list.add(handle);
            }
            arrayList = list;
            Object var17_16 = null;
        }
        catch (Throwable throwable) {
            Object var17_17 = null;
            JDBCUtil.safeClose(rs);
            JDBCUtil.safeClose(st);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(rs);
        JDBCUtil.safeClose(st);
        JDBCUtil.safeClose(con);
        return arrayList;
    }
}

