/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBObject;
import javax.transaction.Transaction;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.CMRInvocation;
import org.jboss.ejb.plugins.lock.Entrancy;
import org.jboss.ejb.plugins.lock.NonReentrantLock;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.EntityMetaData;
import org.jboss.tm.TxUtils;

public class EntityReentranceInterceptor
extends AbstractInterceptor {
    protected boolean reentrant = false;
    private static final Method getEJBHome;
    private static final Method getHandle;
    private static final Method getPrimaryKey;
    private static final Method isIdentical;
    private static final Method remove;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            EntityMetaData meta = (EntityMetaData)container.getBeanMetaData();
            this.reentrant = meta.isReentrant();
        }
    }

    protected boolean isTxExpired(Transaction miTx) throws Exception {
        return TxUtils.isRollback((Transaction)miTx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        Object object;
        EntityEnterpriseContext ctx = (EntityEnterpriseContext)mi.getEnterpriseContext();
        boolean nonReentrant = !this.reentrant && !this.isReentrantMethod(mi);
        NonReentrantLock methodLock = ctx.getMethodLock();
        Transaction miTx = ctx.getTransaction();
        boolean locked = false;
        try {
            while (!locked) {
                if (methodLock.attempt(5000L, miTx, nonReentrant)) {
                    locked = true;
                    continue;
                }
                if (!this.isTxExpired(miTx)) continue;
                this.log.error((Object)("Saw rolled back tx=" + miTx));
                throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
            }
        }
        catch (NonReentrantLock.ReentranceException re) {
            if (mi.getType() == InvocationType.REMOTE) {
                throw new RemoteException("Reentrant method call detected: " + this.container.getBeanMetaData().getEjbName() + " " + ctx.getId().toString());
            }
            throw new EJBException("Reentrant method call detected: " + this.container.getBeanMetaData().getEjbName() + " " + ctx.getId().toString());
        }
        try {
            ctx.lock();
            object = this.getNext().invoke(mi);
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            ctx.unlock();
            methodLock.release(nonReentrant);
            throw throwable;
        }
        ctx.unlock();
        methodLock.release(nonReentrant);
        return object;
    }

    protected boolean isReentrantMethod(Invocation mi) {
        Entrancy entrancy;
        Method m = mi.getMethod();
        if (m != null && (m.equals(getEJBHome) || m.equals(getHandle) || m.equals(getPrimaryKey) || m.equals(isIdentical) || m.equals(remove))) {
            return true;
        }
        if (mi instanceof CMRInvocation && (entrancy = ((CMRInvocation)mi).getEntrancy()) == Entrancy.NON_ENTRANT) {
            this.log.trace((Object)"NON_ENTRANT invocation");
            return true;
        }
        return false;
    }

    static {
        try {
            Class[] noArg = new Class[]{};
            getEJBHome = EJBObject.class.getMethod("getEJBHome", noArg);
            getHandle = EJBObject.class.getMethod("getHandle", noArg);
            getPrimaryKey = EJBObject.class.getMethod("getPrimaryKey", noArg);
            isIdentical = EJBObject.class.getMethod("isIdentical", EJBObject.class);
            remove = EJBObject.class.getMethod("remove", noArg);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }
}

