/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.hornetq.api.core.DiscoveryGroupConfiguration;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactoryMapper
extends MetaMapper<ConnectionFactoryControl> {
    public static final CompositeMetaType TYPE;

    public MetaValue createMetaValue(MetaType metaType, ConnectionFactoryControl control) {
        CompositeValueSupport cvs = new CompositeValueSupport(TYPE);
        cvs.set("name", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getName())));
        TransportConfiguration[] connectors = control.getStaticConnectors();
        DiscoveryGroupConfiguration groupConfiguration = control.getDiscoveryGroupConfiguration();
        StringBuffer connectorNames = new StringBuffer();
        if (groupConfiguration == null) {
            for (TransportConfiguration connector : connectors) {
                if (connectorNames.length() > 0) {
                    connectorNames.append(",");
                }
                connectorNames.append(connector.getName());
            }
        } else {
            connectorNames.append(groupConfiguration.getName());
        }
        cvs.set("ha", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isHA())));
        cvs.set("useDiscovery", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.getDiscoveryGroupConfiguration() != null)));
        cvs.set("connectorNames", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)connectorNames));
        cvs.set("Bindings", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getJndiString(control.getJNDIBindings()))));
        cvs.set("ClientID", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getClientID())));
        cvs.set("DupsOKBatchSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getDupsOKBatchSize())));
        cvs.set("TransactionBatchSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getTransactionBatchSize())));
        cvs.set("ClientFailureCheckPeriod", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getClientFailureCheckPeriod())));
        cvs.set("ConnectionTTL", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getConnectionTTL())));
        cvs.set("CallTimeout", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getCallTimeout())));
        cvs.set("ConsumerWindowSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getConfirmationWindowSize())));
        cvs.set("ConsumerMaxRate", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getConsumerMaxRate())));
        cvs.set("ConfirmationWindowSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getConfirmationWindowSize())));
        cvs.set("ProducerMaxRate", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getProducerMaxRate())));
        cvs.set("ProducerWindowSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getProducerWindowSize())));
        cvs.set("CacheLargeMessagesClient", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isCacheLargeMessagesClient())));
        cvs.set("MinLargeMessageSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getMinLargeMessageSize())));
        cvs.set("BlockOnNonDurableSend", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isBlockOnNonDurableSend())));
        cvs.set("BlockOnAcknowledge", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isBlockOnAcknowledge())));
        cvs.set("BlockOnDurableSend", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isBlockOnDurableSend())));
        cvs.set("AutoGroup", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isAutoGroup())));
        cvs.set("PreAcknowledge", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isPreAcknowledge())));
        cvs.set("MaxRetryInterval", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getMaxRetryInterval())));
        cvs.set("RetryIntervalMultiplier", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Double.valueOf(control.getRetryIntervalMultiplier())));
        cvs.set("ReconnectAttempts", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getReconnectAttempts())));
        cvs.set("ScheduledThreadPoolMaxSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getScheduledThreadPoolMaxSize())));
        cvs.set("ThreadPoolMaxSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getThreadPoolMaxSize())));
        cvs.set("GroupID", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getGroupID())));
        cvs.set("InitialMessagePacketSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Integer.valueOf(control.getInitialMessagePacketSize())));
        cvs.set("UseGlobalPools", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Boolean.valueOf(control.isUseGlobalPools())));
        cvs.set("RetryInterval", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)Long.valueOf(control.getRetryInterval())));
        cvs.set("ConnectionLoadBalancingPolicyClassName", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)control.getConnectionLoadBalancingPolicyClassName())));
        return cvs;
    }

    public ConnectionFactoryControl unwrapMetaValue(MetaValue metaValue) {
        return null;
    }

    public Type mapToType() {
        return ConnectionFactoryControl.class;
    }

    public MetaType getMetaType() {
        return TYPE;
    }

    private String getJndiString(String[] array) {
        StringBuffer sb = new StringBuffer();
        for (String o : array) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(o);
        }
        return sb.toString();
    }

    static {
        String[] itemNames = new String[]{"name", "ha", "useDiscovery", "cfType", "connectorNames", "Bindings", "ClientID", "DupsOKBatchSize", "TransactionBatchSize", "ClientFailureCheckPeriod", "ConnectionTTL", "CallTimeout", "ConsumerWindowSize", "ConsumerMaxRate", "ConfirmationWindowSize", "ProducerMaxRate", "ProducerWindowSize", "CacheLargeMessagesClient", "MinLargeMessageSize", "BlockOnNonDurableSend", "BlockOnAcknowledge", "BlockOnDurableSend", "AutoGroup", "PreAcknowledge", "MaxRetryInterval", "RetryIntervalMultiplier", "ReconnectAttempts", "FailoverOnServerShutdown", "ScheduledThreadPoolMaxSize", "ThreadPoolMaxSize", "GroupID", "InitialMessagePacketSize", "UseGlobalPools", "RetryInterval", "ConnectionLoadBalancingPolicyClassName"};
        String[] itemDescriptions = new String[]{"name", "ha", "useDiscovery", "cfType", "connectorNames", "Bindings", "ClientID", "DupsOKBatchSize", "TransactionBatchSize", "ClientFailureCheckPeriod", "ConnectionTTL", "CallTimeout", "ConsumerWindowSize", "ConsumerMaxRate", "ConfirmationWindowSize", "ProducerMaxRate", "ProducerWindowSize", "CacheLargeMessagesClient", "MinLargeMessageSize", "BlockOnNonDurableSend", "BlockOnAcknowledge", "BlockOnDurableSend", "AutoGroup", "PreAcknowledge", "MaxRetryInterval", "RetryIntervalMultiplier", "ReconnectAttempts", "FailoverOnServerShutdown", "ScheduledThreadPoolMaxSize", "ThreadPoolMaxSize", "GroupID", "InitialMessagePacketSize", "UseGlobalPools", "RetryInterval", "ConnectionLoadBalancingPolicyClassName"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING};
        TYPE = new ImmutableCompositeMetaType("javax.jms.ConnectionFactory", "Connection Factory Settings", itemNames, itemDescriptions, itemTypes);
    }
}

