/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import org.hornetq.api.jms.management.ConnectionFactoryControl;
import org.hornetq.api.jms.management.JMSServerControl;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.management.ManagementService;
import org.jboss.as.integration.hornetq.management.jms.ConnectionFactoryMapper;
import org.jboss.as.integration.hornetq.management.jms.JMSManageMO;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.metatype.api.annotations.MetaMapping;

@ManagementObject(componentType=@ManagementComponent(type="JMSManage", subtype="ConnectionFactoryManage"), properties=ManagementProperties.EXPLICIT, isRuntime=true)
public class ConnectionFactoryManageMO
extends JMSManageMO {
    public ConnectionFactoryManageMO(HornetQServer server) {
        super(server);
    }

    @ManagementOperation(name="deleteConnectionFactory", description="returns the JMS Connection Factory configuration", params={@ManagementParameter(name="name", description="the connection factory name")})
    public void deleteConnectionFactory(String name) throws Exception {
        JMSServerControl jmsServerControl = this.getJmsServerControl();
        jmsServerControl.destroyConnectionFactory(name);
    }

    @ManagementOperation(name="getConfiguration", description="returns the JMS Connection Factory configuration", params={@ManagementParameter(name="name", description="the connection factory name")})
    @MetaMapping(value=ConnectionFactoryMapper.class)
    public ConnectionFactoryControl getConfiguration(String name) {
        return (ConnectionFactoryControl)this.getManagementService().getResource("jms.connectionfactory." + name);
    }

    @ManagementOperation(name="getMeasurements", description="gets a connection factories", params={@ManagementParameter(name="name", description="the queue name"), @ManagementParameter(name="names", description="the measurement names")})
    public String[] getMeasurements(String name, String[] names) throws Exception {
        ManagementService managementService = this.getManagementService();
        ConnectionFactoryControl control = (ConnectionFactoryControl)managementService.getResource("jms.connectionfactory." + name);
        String[] val = new String[names.length];
        int valLength = val.length;
        for (int i = 0; i < valLength; ++i) {
            Object o = control.getClass().getMethod(names[i], new Class[0]).invoke((Object)control, new Object[0]);
            val[i] = o instanceof Object[] ? this.coomaSeparatedString((Object[])o) : o.toString();
        }
        return val;
    }

    @ManagementOperation(name="getConnectionFactories", description="returns the JMS Connection Factories")
    public String[] getJMSConnectionFactories() {
        JMSServerControl jmsServerControl = this.getJmsServerControl();
        if (jmsServerControl == null) {
            return new String[0];
        }
        return jmsServerControl.getConnectionFactoryNames();
    }

    @ManagementOperation(name="createConnectionFactory", description="creates a connection factories", params={@ManagementParameter(name="name", description="the connection factory name"), @ManagementParameter(name="ha", description="does the connection factory support high availibility"), @ManagementParameter(name="useDiscovery", description="should we use a discovery group configuration or a connector configuration"), @ManagementParameter(name="cfType", description="the type of connection factory"), @ManagementParameter(name="connectorNames", description="comma-separated list of connectors to uses"), @ManagementParameter(name="bindings", description="comma-separated list of JNDI bindings"), @ManagementParameter(name="clientId", description="the client id"), @ManagementParameter(name="dupsOkBatchSize", description="the batch size for DUPS_OK acknowledge mode"), @ManagementParameter(name="transactionBatchSize", description="the transaction batch size"), @ManagementParameter(name="clientFailureCheckPeriod", description="the client failure check period"), @ManagementParameter(name="connectionTTL", description="the connection time to live"), @ManagementParameter(name="callTimeout", description="the remote call timeout"), @ManagementParameter(name="consumerWindowSize", description="the consumer window size"), @ManagementParameter(name="confirmationWindowSize", description="the confirmation window size"), @ManagementParameter(name="producerMaxRate", description="the produxer max rate"), @ManagementParameter(name="producerWindowSize", description="the producer window size"), @ManagementParameter(name="cacheLargeMessageClient", description="do we cache large messages on the client"), @ManagementParameter(name="minLargeMessageSize", description="the minimum large message size"), @ManagementParameter(name="blockOnNonDurableSend", description="do we block on non durable send"), @ManagementParameter(name="blockOnAcknowledge", description="do we block on acknowledge"), @ManagementParameter(name="blockOnDurableSend", description="do we block on durable send"), @ManagementParameter(name="autoGroup", description="do we use autogroup"), @ManagementParameter(name="preAcknowledge", description="do we pre acknowledge messages"), @ManagementParameter(name="maxRetryInterval", description="the max retry interval"), @ManagementParameter(name="retryIntervalMultiplier", description="the max retry interval multiplier"), @ManagementParameter(name="reconnectAttempts", description="the reconnect attempts"), @ManagementParameter(name="scheduledThreadPoolMaxSize", description="the pool size for scheduled threads"), @ManagementParameter(name="threadPoolMaxSize", description="the pool size for threads"), @ManagementParameter(name="groupId", description="the group id"), @ManagementParameter(name="initialMessagePacketSize", description="the initial message packet size"), @ManagementParameter(name="useGlobalPools", description="do we use global pools"), @ManagementParameter(name="retryInterval", description="the retry interval"), @ManagementParameter(name="connectionLoadBalancingPolicyClassName", description="the load balancing class")})
    public void createConnectionFactory(String name, boolean ha, boolean useDiscovery, int cfType, String connectorNames, String bindings, String clientId, int dupsOkBatchSize, int transactionBatchSize, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, int consumerWindowSize, int confirmationWindowSize, int producerMaxRate, int producerWindowSize, boolean cacheLargeMessageClient, int minLargeMessageSize, boolean blockOnNonDurableSend, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean autoGroup, boolean preAcknowledge, long maxRetryInterval, double retryIntervalMultiplier, int reconnectAttempts, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, String groupId, int initialMessagePacketSize, boolean useGlobalPools, long retryInterval, String connectionLoadBalancingPolicyClassName) throws Exception {
        JMSServerControl jmsServerControl = this.getJmsServerControl();
        jmsServerControl.createConnectionFactory(name, ha, useDiscovery, cfType, connectorNames, bindings);
        ManagementService managementService = this.getManagementService();
        ConnectionFactoryControl control = (ConnectionFactoryControl)managementService.getResource("jms.connectionfactory." + name);
        control.setClientID(clientId);
        control.setDupsOKBatchSize(dupsOkBatchSize);
        control.setTransactionBatchSize(transactionBatchSize);
        control.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        control.setConnectionTTL(connectionTTL);
        control.setCallTimeout(callTimeout);
        control.setConsumerWindowSize(consumerWindowSize);
        control.setConfirmationWindowSize(confirmationWindowSize);
        control.setProducerMaxRate(producerMaxRate);
        control.setProducerWindowSize(producerWindowSize);
        control.setCacheLargeMessagesClient(cacheLargeMessageClient);
        control.setMinLargeMessageSize(minLargeMessageSize);
        control.setBlockOnDurableSend(blockOnNonDurableSend);
        control.setBlockOnAcknowledge(blockOnAcknowledge);
        control.setBlockOnDurableSend(blockOnDurableSend);
        control.setAutoGroup(autoGroup);
        control.setPreAcknowledge(preAcknowledge);
        control.setMaxRetryInterval(maxRetryInterval);
        control.setRetryIntervalMultiplier(retryIntervalMultiplier);
        control.setReconnectAttempts(reconnectAttempts);
        control.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        control.setThreadPoolMaxSize(threadPoolMaxSize);
        control.setGroupID(groupId);
        control.setUseGlobalPools(useGlobalPools);
        control.setRetryInterval(retryInterval);
        control.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }

    @ManagementOperation(name="createConnectionFactory", description="creates a connection factories", params={@ManagementParameter(name="name", description="the connection factory name"), @ManagementParameter(name="ha", description="does the connection factory support high availibility"), @ManagementParameter(name="clientId", description="the client id"), @ManagementParameter(name="dupsOkBatchSize", description="the batch size for DUPS_OK acknowledge mode"), @ManagementParameter(name="transactionBatchSize", description="the transaction batch size"), @ManagementParameter(name="clientFailureCheckPeriod", description="the client failure check period"), @ManagementParameter(name="connectionTTL", description="the connection time to live"), @ManagementParameter(name="callTimeout", description="the remote call timeout"), @ManagementParameter(name="consumerWindowSize", description="the consumer window size"), @ManagementParameter(name="confirmationWindowSize", description="the confirmation window size"), @ManagementParameter(name="producerMaxRate", description="the produxer max rate"), @ManagementParameter(name="producerWindowSize", description="the producer window size"), @ManagementParameter(name="cacheLargeMessageClient", description="do we cache large messages on the client"), @ManagementParameter(name="minLargeMessageSize", description="the minimum large message size"), @ManagementParameter(name="blockOnNonDurableSend", description="do we block on non durable send"), @ManagementParameter(name="blockOnAcknowledge", description="do we block on acknowledge"), @ManagementParameter(name="blockOnDurableSend", description="do we block on durable send"), @ManagementParameter(name="autoGroup", description="do we use autogroup"), @ManagementParameter(name="preAcknowledge", description="do we pre acknowledge messages"), @ManagementParameter(name="maxRetryInterval", description="the max retry interval"), @ManagementParameter(name="retryIntervalMultiplier", description="the max retry interval multiplier"), @ManagementParameter(name="reconnectAttempts", description="the reconnect attempts"), @ManagementParameter(name="scheduledThreadPoolMaxSize", description="the pool size for scheduled threads"), @ManagementParameter(name="threadPoolMaxSize", description="the pool size for threads"), @ManagementParameter(name="groupId", description="the group id"), @ManagementParameter(name="initialMessagePacketSize", description="the initial message packet size"), @ManagementParameter(name="useGlobalPools", description="do we use global pools"), @ManagementParameter(name="retryInterval", description="the retry interval"), @ManagementParameter(name="connectionLoadBalancingPolicyClassName", description="the load balancing class")})
    public void updateConnectionFactory(String name, String clientId, int dupsOkBatchSize, int transactionBatchSize, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, int consumerWindowSize, int confirmationWindowSize, int producerMaxRate, int producerWindowSize, boolean cacheLargeMessageClient, int minLargeMessageSize, boolean blockOnNonDurableSend, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean autoGroup, boolean preAcknowledge, long maxRetryInterval, double retryIntervalMultiplier, int reconnectAttempts, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, String groupId, int initialMessagePacketSize, boolean useGlobalPools, long retryInterval, String connectionLoadBalancingPolicyClassName) throws Exception {
        ManagementService managementService = this.getManagementService();
        ConnectionFactoryControl control = (ConnectionFactoryControl)managementService.getResource("jms.connectionfactory." + name);
        control.setClientID(clientId);
        control.setDupsOKBatchSize(dupsOkBatchSize);
        control.setTransactionBatchSize(transactionBatchSize);
        control.setClientFailureCheckPeriod(clientFailureCheckPeriod);
        control.setConnectionTTL(connectionTTL);
        control.setCallTimeout(callTimeout);
        control.setConsumerWindowSize(consumerWindowSize);
        control.setConfirmationWindowSize(confirmationWindowSize);
        control.setProducerMaxRate(producerMaxRate);
        control.setProducerWindowSize(producerWindowSize);
        control.setCacheLargeMessagesClient(cacheLargeMessageClient);
        control.setMinLargeMessageSize(minLargeMessageSize);
        control.setBlockOnDurableSend(blockOnNonDurableSend);
        control.setBlockOnAcknowledge(blockOnAcknowledge);
        control.setBlockOnDurableSend(blockOnDurableSend);
        control.setAutoGroup(autoGroup);
        control.setPreAcknowledge(preAcknowledge);
        control.setMaxRetryInterval(maxRetryInterval);
        control.setRetryIntervalMultiplier(retryIntervalMultiplier);
        control.setReconnectAttempts(reconnectAttempts);
        control.setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize);
        control.setThreadPoolMaxSize(threadPoolMaxSize);
        control.setGroupID(groupId);
        control.setUseGlobalPools(useGlobalPools);
        control.setRetryInterval(retryInterval);
        control.setConnectionLoadBalancingPolicyClassName(connectionLoadBalancingPolicyClassName);
    }
}

