/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.jms;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.hornetq.api.core.management.AddressSettingsInfo;
import org.hornetq.api.core.management.RoleInfo;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.hornetq.jms.server.config.TopicConfiguration;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressSettingsMapper
extends MetaMapper<Object[]> {
    public static final CompositeMetaType ADDRESS_SETTINGS_TYPE;
    public static final CompositeMetaType SECURITY_TYPE;
    public static final CollectionMetaType TYPE;

    public MetaValue createMetaValue(MetaType metaType, Object[] val) {
        CompositeValueSupport cvs = new CompositeValueSupport(ADDRESS_SETTINGS_TYPE);
        if (val[0] instanceof JMSQueueConfiguration) {
            JMSQueueConfiguration queueConfiguration = (JMSQueueConfiguration)val[0];
            cvs.set("name", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)queueConfiguration.getName())));
            cvs.set("jndiBindings", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getJndiString(queueConfiguration.getBindings()))));
        } else {
            TopicConfiguration topicConfiguration = (TopicConfiguration)val[0];
            cvs.set("name", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)topicConfiguration.getName())));
            cvs.set("jndiBindings", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)this.getJndiString(topicConfiguration.getBindings()))));
        }
        AddressSettingsInfo addressSettings = (AddressSettingsInfo)val[1];
        cvs.set("dla", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)addressSettings.getDeadLetterAddress())));
        cvs.set("expiryAddress", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)addressSettings.getExpiryAddress())));
        cvs.set("maxSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Long.valueOf(addressSettings.getMaxSizeBytes())));
        cvs.set("pageSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(addressSettings.getPageSizeBytes())));
        cvs.set("pageMaxCacheSize", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(addressSettings.getPageCacheMaxSize())));
        cvs.set("maxDeliveryAttempts", (MetaValue)new SimpleValueSupport(SimpleMetaType.INTEGER_PRIMITIVE, (Serializable)Integer.valueOf(addressSettings.getMaxDeliveryAttempts())));
        cvs.set("redeliveryDelay", (MetaValue)new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(addressSettings.getRedeliveryDelay())));
        cvs.set("lastValueQueue", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(addressSettings.isLastValueQueue())));
        cvs.set("redistributionDelay", (MetaValue)new SimpleValueSupport(SimpleMetaType.LONG_PRIMITIVE, (Serializable)Long.valueOf(addressSettings.getRedistributionDelay())));
        cvs.set("sendToDLAOnNoRoute", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(addressSettings.isSendToDLAOnNoRoute())));
        cvs.set("addressFullMessagePolicy", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)addressSettings.getAddressFullMessagePolicy())));
        if (val.length == 3) {
            RoleInfo[] roles;
            ArrayList<CompositeValueSupport> tmp = new ArrayList<CompositeValueSupport>();
            for (RoleInfo role : roles = (RoleInfo[])val[2]) {
                CompositeValueSupport cvs2 = new CompositeValueSupport(SECURITY_TYPE);
                cvs2.set("name", (MetaValue)new SimpleValueSupport(SimpleMetaType.STRING, (Serializable)((Object)role.getName())));
                cvs2.set("send", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(role.isSend())));
                cvs2.set("consume", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(role.isConsume())));
                cvs2.set("createDurableQueue", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(role.isCreateDurableQueue())));
                cvs2.set("deleteDurableQueue", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(role.isDeleteDurableQueue())));
                cvs2.set("createNonDurableQueue", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(role.isCreateNonDurableQueue())));
                cvs2.set("deleteNonDurableQueue", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(role.isDeleteNonDurableQueue())));
                cvs2.set("manage", (MetaValue)new SimpleValueSupport(SimpleMetaType.BOOLEAN_PRIMITIVE, (Serializable)Boolean.valueOf(role.isManage())));
                tmp.add(cvs2);
            }
            MetaValue[] elements = new MetaValue[tmp.size()];
            tmp.toArray(elements);
            CollectionValueSupport sec = new CollectionValueSupport(TYPE, elements);
            cvs.set("roles", (MetaValue)sec);
        }
        return cvs;
    }

    public Object[] unwrapMetaValue(MetaValue metaValue) {
        return null;
    }

    public Type mapToType() {
        return Object[].class;
    }

    public MetaType getMetaType() {
        return ADDRESS_SETTINGS_TYPE;
    }

    private String getJndiString(String[] array) {
        StringBuffer sb = new StringBuffer();
        int arrayLength = array.length;
        for (int i = 0; i < arrayLength; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    static {
        String[] securityNames = new String[]{"name", "send", "consume", "createDurableQueue", "deleteDurableQueue", "createNonDurableQueue", "deleteNonDurableQueue", "manage"};
        String[] securityDescription = new String[]{"name", "send", "consume", "createDurableQueue", "deleteDurableQueue", "createNonDurableQueue", "deleteNonDurableQueue", "manage"};
        MetaType[] securityTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE};
        SECURITY_TYPE = new ImmutableCompositeMetaType("org.hornetq.api.core.management.RoleInfo", "Roles", securityNames, securityDescription, securityTypes);
        TYPE = new CollectionMetaType("java.util.List", (MetaType)SECURITY_TYPE);
        String[] itemNames = new String[]{"name", "jndiBindings", "dla", "expiryAddress", "maxSize", "pageSize", "pageMaxCacheSize", "maxDeliveryAttempts", "redeliveryDelay", "lastValueQueue", "redistributionDelay", "sendToDLAOnNoRoute", "addressFullMessagePolicy", "roles"};
        String[] itemDescriptions = new String[]{"name", "jndiBindings", "dla", "expiryAddress", "maxSize", "pageSize", "pageMaxCacheSize", "maxDeliveryAttempts", "redeliveryDelay", "lastValueQueue", "redistributionDelay", "sendToDLAOnNoRoute", "addressFullMessagePolicy", "roles"};
        MetaType[] itemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.INTEGER_PRIMITIVE, SimpleMetaType.INTEGER_PRIMITIVE, SimpleMetaType.INTEGER_PRIMITIVE, SimpleMetaType.INTEGER_PRIMITIVE, SimpleMetaType.LONG_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.LONG_PRIMITIVE, SimpleMetaType.BOOLEAN_PRIMITIVE, SimpleMetaType.STRING, TYPE};
        ADDRESS_SETTINGS_TYPE = new ImmutableCompositeMetaType("org.hornetq.api.core.management.AddressSettingsInfo", "Address Settings", itemNames, itemDescriptions, itemTypes);
    }
}

