/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers.pojo;

import java.util.Map;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.BridgeConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.logging.Logger;

public class HornetQCoreDeployment {
    private static final Logger log = Logger.getLogger(HornetQCoreDeployment.class);
    private HornetQServer server;
    private String name;
    private String jmxDomain;
    private Configuration config;

    public Configuration getJmsConfig() {
        return this.config;
    }

    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public void setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public HornetQServer getServer() {
        return this.server;
    }

    public void setServer(HornetQServer server) {
        this.server = server;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Start
    public void start() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.name + " is being started"));
        }
        if (!this.jmxDomain.equals(this.server.getConfiguration().getJMXDomain())) {
            return;
        }
        for (Map.Entry entry : this.config.getAddressesSettings().entrySet()) {
            this.server.getAddressSettingsRepository().addMatch((String)entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : this.config.getSecurityRoles().entrySet()) {
            this.server.getSecurityRepository().addMatch((String)entry.getKey(), entry.getValue());
        }
        for (CoreQueueConfiguration coreQueue : this.config.getQueueConfigurations()) {
            try {
                this.server.deployQueue(new SimpleString(coreQueue.getAddress()), new SimpleString(coreQueue.getName()), SimpleString.toSimpleString((String)coreQueue.getFilterString()), coreQueue.isDurable(), false);
            }
            catch (Exception e) {
                log.warn((Object)("Error on creating queue " + coreQueue.getName() + " address = " + coreQueue.getAddress()), (Throwable)e);
            }
        }
        for (BridgeConfiguration bridgeConfiguration : this.config.getBridgeConfigurations()) {
            try {
                this.server.deployBridge(bridgeConfiguration);
            }
            catch (Exception e) {
                log.warn((Object)("Error deploying Bridge " + bridgeConfiguration.getName()), (Throwable)e);
            }
        }
    }

    @Stop
    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace((Object)(this.name + " is being stopped"));
        }
        if (!this.jmxDomain.equals(this.server.getConfiguration().getJMXDomain())) {
            return;
        }
        for (String entry : this.config.getAddressesSettings().keySet()) {
            this.server.getAddressSettingsRepository().removeMatch(entry);
        }
        for (String entry : this.config.getSecurityRoles().keySet()) {
            this.server.getSecurityRepository().removeMatch(entry);
        }
    }
}

