/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers;

import java.io.InputStream;
import org.hornetq.jms.server.JMSServerConfigParser;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.impl.JMSServerConfigParserImpl;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HornetQJMSParserDeployer
extends AbstractVFSParsingDeployer<JMSConfiguration> {
    private static final Logger log = Logger.getLogger(HornetQJMSParserDeployer.class);
    public static final String FILENAME = "hornetq-jms.xml";
    private final JMSServerConfigParser jmsConfigParser = new JMSServerConfigParserImpl();

    public HornetQJMSParserDeployer() {
        super(JMSConfiguration.class);
        this.setSuffix(FILENAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JMSConfiguration parse(VFSDeploymentUnit unit, VirtualFile file, JMSConfiguration root) throws Exception {
        InputStream deploymentStream = null;
        try {
            deploymentStream = file.openStream();
            JMSConfiguration config = this.jmsConfigParser.parseConfiguration(deploymentStream);
            if (log.isTraceEnabled()) {
                log.trace((Object)("JMS config parser parsed config = " + config));
            }
            JMSConfiguration jMSConfiguration = config;
            return jMSConfiguration;
        }
        finally {
            try {
                deploymentStream.close();
            }
            catch (Exception ignored) {}
        }
    }
}

