/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.jboss.modcluster.ServerProvider;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.config.BalancerConfiguration;
import org.jboss.modcluster.config.NodeConfiguration;
import org.jboss.modcluster.mcmp.MCMPRequest;
import org.jboss.modcluster.mcmp.MCMPRequestFactory;
import org.jboss.modcluster.mcmp.MCMPRequestType;
import org.jboss.modcluster.mcmp.ResetRequestSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetRequestSourceImpl
implements ResetRequestSource {
    private final NodeConfiguration nodeConfig;
    private final BalancerConfiguration balancerConfig;
    private final ServerProvider<Server> serverProvider;
    private final MCMPRequestFactory requestFactory;
    private volatile Map<String, Set<String>> excludedContexts;

    public ResetRequestSourceImpl(NodeConfiguration nodeConfig, BalancerConfiguration balancerConfig, ServerProvider<Server> serverProvider, MCMPRequestFactory requestFactory) {
        this.nodeConfig = nodeConfig;
        this.balancerConfig = balancerConfig;
        this.serverProvider = serverProvider;
        this.requestFactory = requestFactory;
    }

    @Override
    public void init(Map<String, Set<String>> excludedContexts) {
        this.excludedContexts = excludedContexts;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<MCMPRequest> getResetRequests(Map<String, Set<ResetRequestSource.VirtualHost>> response) {
        ArrayList<MCMPRequest> requests = new ArrayList<MCMPRequest>();
        Server server = this.serverProvider.getServer();
        if (server == null) {
            return requests;
        }
        LinkedList<MCMPRequest> engineRequests = new LinkedList<MCMPRequest>();
        for (Service service : server.findServices()) {
            Engine engine = (Engine)service.getContainer();
            engineRequests.add(this.requestFactory.createConfigRequest(engine, this.nodeConfig, this.balancerConfig));
            Set<Object> responseHosts = Collections.emptySet();
            String jvmRoute = engine.getJvmRoute();
            if (response.containsKey(jvmRoute)) {
                responseHosts = response.get(jvmRoute);
            }
            for (Container child : engine.findChildren()) {
                void var21_21;
                Host host = (Host)child;
                String hostName = host.getName();
                Set<String> aliases = Utils.getAliases(host);
                ResetRequestSource.VirtualHost responseHost = null;
                for (ResetRequestSource.VirtualHost virtualHost : responseHosts) {
                    if (!virtualHost.getAliases().contains(hostName)) continue;
                    responseHost = virtualHost;
                    break;
                }
                Set<String> responseAliases = Collections.emptySet();
                Map map = Collections.emptyMap();
                if (responseHost != null) {
                    responseAliases = responseHost.getAliases();
                    if (!((Object)aliases).equals(responseAliases)) {
                        engineRequests.add(0, this.requestFactory.createRemoveRequest(engine));
                    } else {
                        Map<String, ResetRequestSource.Status> map2 = responseHost.getContexts();
                    }
                }
                HashSet obsoleteContexts = new HashSet(var21_21.keySet());
                for (Container container : host.findChildren()) {
                    Context context = (Context)container;
                    String path = context.getPath();
                    Set<String> excludedPaths = this.excludedContexts.get(hostName);
                    if (excludedPaths != null && excludedPaths.contains(path)) continue;
                    if (path.equals("")) {
                        path = "/";
                    }
                    obsoleteContexts.remove(path);
                    ResetRequestSource.Status status = (ResetRequestSource.Status)((Object)var21_21.get(path));
                    if (Utils.isContextStarted(context)) {
                        if (status == ResetRequestSource.Status.ENABLED) continue;
                        engineRequests.add(this.requestFactory.createEnableRequest(context));
                        continue;
                    }
                    if (status != ResetRequestSource.Status.ENABLED) continue;
                    engineRequests.add(this.requestFactory.createStopRequest(context));
                }
                if (obsoleteContexts.isEmpty()) continue;
                if (obsoleteContexts.size() == var21_21.size()) {
                    engineRequests.add(0, this.requestFactory.createRemoveRequest(engine));
                    continue;
                }
                for (String context : obsoleteContexts) {
                    engineRequests.add(0, this.requestFactory.createRequest(MCMPRequestType.REMOVE_APP, jvmRoute, responseAliases, context));
                }
            }
            requests.addAll(engineRequests);
            engineRequests.clear();
        }
        return requests;
    }
}

