/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.mcmp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.jboss.modcluster.Utils;
import org.jboss.modcluster.mcmp.MCMPHandler;

public abstract class AbstractMCMPHandler
implements MCMPHandler {
    public void addProxy(String address) {
        InetSocketAddress socketAddress = Utils.parseSocketAddress(address);
        this.addProxy(socketAddress.getAddress(), socketAddress.getPort());
    }

    public void addProxy(String host, int port) {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.addProxy(address, port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void removeProxy(String host, int port) {
        try {
            InetAddress address = InetAddress.getByName(host);
            this.removeProxy(address, port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

