/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Message;

public class DeliveringCounter {
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_COUNTER = 1;
    public static final int LEVEL_ALL = 255;
    private static final Logger log = Logger.getLogger(DeliveringCounter.class);
    private int level = 1;
    private ConcurrentHashMap<Long, Message> msgCount;
    private ConcurrentLinkedQueue<Message> earlyMsgs;
    private AtomicInteger counter;

    public DeliveringCounter() {
        this(1);
    }

    public DeliveringCounter(int lv) {
        this.initLevel(lv);
    }

    private void initLevel(int lv) {
        this.level = lv;
        log.debug((Object)("Delivering Counter enabled: " + this.level));
        if (this.level == 0) {
            return;
        }
        this.counter = new AtomicInteger(0);
        if (this.level == 255) {
            this.msgCount = new ConcurrentHashMap();
            this.earlyMsgs = new ConcurrentLinkedQueue();
        }
    }

    public void decrement(Message acked) {
        if (this.level == 0) {
            return;
        }
        this.counter.decrementAndGet();
        if (this.level != 255) {
            return;
        }
        Message m = this.msgCount.remove(acked.getMessageID());
        if (m == null) {
            this.earlyMsgs.add(acked);
        }
    }

    public void increment(Message msg) {
        if (this.level == 0) {
            return;
        }
        this.counter.incrementAndGet();
        if (this.level != 255) {
            return;
        }
        this.msgCount.put(msg.getMessageID(), msg);
    }

    public int get() {
        if (this.level == 0) {
            return 0;
        }
        return this.counter.get();
    }

    public void reset() {
        if (this.level == 0) {
            return;
        }
        this.counter.set(0);
        if (this.level != 255) {
            return;
        }
        this.earlyMsgs.clear();
        this.msgCount.clear();
    }

    public synchronized List getMessages() {
        if (this.level != 255) {
            return new ArrayList();
        }
        Iterator<Message> iterId = this.earlyMsgs.iterator();
        while (iterId.hasNext()) {
            Message acked = iterId.next();
            Message m = this.msgCount.remove(acked.getMessageID());
            if (m == null) continue;
            iterId.remove();
        }
        Iterator<Message> iter = this.msgCount.values().iterator();
        ArrayList<Message> list = new ArrayList<Message>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public void setLevel(int lv) {
        this.initLevel(lv);
    }

    public int getLevel() {
        return this.level;
    }

    public static String toString(int lvl) throws Exception {
        if (lvl == 0) {
            return "NONE";
        }
        if (lvl == 1) {
            return "COUNTER";
        }
        if (lvl == 255) {
            return "ALL";
        }
        throw new Exception("Invalid value: " + lvl);
    }

    public static int toLevel(String lvl) throws Exception {
        if ("NONE".equals(lvl)) {
            return 0;
        }
        if ("COUNTER".equals(lvl)) {
            return 1;
        }
        if ("ALL".equals(lvl)) {
            return 255;
        }
        throw new Exception("Invalid value: \"" + lvl + "\"");
    }
}

