/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.jms.JMSException;
import org.jboss.aop.AspectManager;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.delegate.ConnectionFactoryEndpoint;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.delegate.TopologyResult;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.connectionfactory.JNDIBindings;
import org.jboss.jms.server.endpoint.SecurityActions;
import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
import org.jboss.jms.server.endpoint.advised.ConnectionAdvised;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.ConcurrentHashSet;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.security.SecurityContext;

public class ServerConnectionFactoryEndpoint
implements ConnectionFactoryEndpoint {
    private static final Logger log = Logger.getLogger(ServerConnectionFactoryEndpoint.class);
    private ServerPeer serverPeer;
    private String clientID;
    private String uniqueName;
    private String id;
    private JNDIBindings jndiBindings;
    private int prefetchSize;
    private int defaultTempQueueFullSize;
    private int defaultTempQueuePageSize;
    private int defaultTempQueueDownCacheSize;
    private int dupsOKBatchSize;
    private boolean supportsFailover;
    private boolean slowConsumers;
    private ClientConnectionFactoryDelegate[] delegates;
    private Map failoverMap;
    private Set<InvokerCallbackHandler> handlers = new ConcurrentHashSet<InvokerCallbackHandler>();

    public ServerConnectionFactoryEndpoint(String uniqueName, String id, ServerPeer serverPeer, String defaultClientID, JNDIBindings jndiBindings, int preFetchSize, boolean slowConsumers, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int dupsOKBatchSize, boolean supportsFailover) {
        this.uniqueName = uniqueName;
        this.serverPeer = serverPeer;
        this.clientID = defaultClientID;
        this.id = id;
        this.jndiBindings = jndiBindings;
        this.prefetchSize = preFetchSize;
        this.defaultTempQueueFullSize = defaultTempQueueFullSize;
        this.defaultTempQueuePageSize = defaultTempQueuePageSize;
        this.defaultTempQueueDownCacheSize = defaultTempQueueDownCacheSize;
        this.dupsOKBatchSize = dupsOKBatchSize;
        this.supportsFailover = supportsFailover;
        this.slowConsumers = slowConsumers;
        if (slowConsumers) {
            this.prefetchSize = 1;
        }
    }

    public CreateConnectionResult createConnectionDelegate(String username, String password, int failedNodeID) throws JMSException {
        throw new IllegalStateException("createConnectionDelegate should never be called directly");
    }

    public CreateConnectionResult createConnectionDelegate(String username, String password, int failedNodeID, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler) throws JMSException {
        try {
            if (failedNodeID == -1) {
                ClientConnectionDelegate cd = this.createConnectionDelegateInternal(username, password, failedNodeID, remotingSessionID, clientVMID, versionToUse, callbackHandler);
                return new CreateConnectionResult(cd);
            }
            log.trace((Object)(this + " received client-side failover request. Creating failover " + "connection to replace connection to failed node " + failedNodeID));
            int failoverNodeID = this.serverPeer.getFailoverWaiter().waitForFailover(failedNodeID);
            if (failoverNodeID == -1 || failoverNodeID != this.serverPeer.getServerPeerID()) {
                log.trace((Object)(this + " realized that we are on the wrong node or no failover has occured"));
                return new CreateConnectionResult(failoverNodeID);
            }
            log.trace((Object)(this + " received notification that server-side failover completed, " + "creating connection delegate ..."));
            ClientConnectionDelegate cd = this.createConnectionDelegateInternal(username, password, failedNodeID, remotingSessionID, clientVMID, versionToUse, callbackHandler);
            return new CreateConnectionResult(cd);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createFailoverConnectionDelegate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnectionDelegate createConnectionDelegateInternal(final String username, final String password, int failedNodeID, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler) throws Exception {
        ConnectionAdvised connAdvised;
        String preconfClientID;
        log.trace((Object)("creating a new connection for user " + username));
        SecurityContext previousSCtx = SecurityActions.getSecurityContext();
        if (System.getSecurityManager() == null) {
            this.serverPeer.getSecurityManager().authenticate(username, password);
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        ServerConnectionFactoryEndpoint.this.serverPeer.getSecurityManager().authenticate(username, password);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException pe) {
                throw pe.getException();
            }
        }
        SecurityActions.setSecurityContext(previousSCtx);
        String clientIDUsed = this.clientID;
        if (username != null && (preconfClientID = this.serverPeer.getJmsUserManagerInstance().getPreConfiguredClientID(username)) != null) {
            clientIDUsed = preconfClientID;
        }
        ServerConnectionEndpoint endpoint = new ServerConnectionEndpoint(this.serverPeer, clientIDUsed, username, password, this.prefetchSize, this.defaultTempQueueFullSize, this.defaultTempQueuePageSize, this.defaultTempQueueDownCacheSize, failedNodeID, this, remotingSessionID, clientVMID, versionToUse, callbackHandler, this.dupsOKBatchSize);
        String connectionID = endpoint.getConnectionID();
        AspectManager aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            connAdvised = new ConnectionAdvised(endpoint);
        }
        Dispatcher.instance.registerTarget(connectionID, connAdvised);
        log.trace((Object)("created and registered " + endpoint));
        aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            return new ClientConnectionDelegate(connectionID, this.serverPeer.getServerPeerID());
        }
    }

    public byte[] getClientAOPStack() throws JMSException {
        try {
            return this.serverPeer.getClientAOPStack();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getClientAOPStack");
        }
    }

    public void addCallback(String VMID, String remotingSessionID, InvokerCallbackHandler callbackHandler) throws JMSException {
        log.debug((Object)"Adding callbackHandler on ConnectionFactory");
        this.handlers.add(callbackHandler);
        this.serverPeer.getConnectionManager().registerConnectionFactoryCallback(VMID, remotingSessionID, callbackHandler);
    }

    public void removeCallback(String VMID, String remotingSessionID, ServerInvokerCallbackHandler callbackHandler) throws JMSException {
        log.debug((Object)"Removing callbackHandler on ConnectionFactory");
        this.handlers.remove(callbackHandler);
        this.serverPeer.getConnectionManager().unregisterConnectionFactoryCallback(VMID, remotingSessionID);
    }

    public TopologyResult getTopology() throws JMSException {
        return new TopologyResult(this.uniqueName, this.delegates, this.failoverMap);
    }

    public void removeCallbackhandler(InvokerCallbackHandler handler) {
        this.handlers.remove(handler);
    }

    public String getID() {
        return this.id;
    }

    public JNDIBindings getJNDIBindings() {
        return this.jndiBindings;
    }

    public ServerPeer getServerPeer() {
        return this.serverPeer;
    }

    public void updateClusteredClients(ClientConnectionFactoryDelegate[] delegates, Map failoverMap) throws Exception {
        this.updateTopology(delegates, failoverMap);
        log.debug((Object)("updateClusteredClients being called!!! clientFactoriesToUpdate.size = " + this.handlers.size()));
        ConnectionFactoryUpdate message = new ConnectionFactoryUpdate(this.uniqueName, delegates, failoverMap);
        Callback callback = new Callback((Object)message);
        for (InvokerCallbackHandler o : this.handlers) {
            log.debug((Object)("Updating CF on callback " + o));
            ((ServerInvokerCallbackHandler)o).handleCallbackOneway(callback);
        }
    }

    public void updateTopology(ClientConnectionFactoryDelegate[] delegates, Map failoverMap) {
        this.delegates = delegates;
        this.failoverMap = failoverMap;
    }

    public boolean isSlowConsumers() {
        return this.slowConsumers;
    }

    public String toString() {
        return "ConnectionFactoryEndpoint[" + this.id + "]";
    }

    public Set getCallbackHandlers() {
        return Collections.unmodifiableSet(this.handlers);
    }

    boolean isSupportsFailover() {
        return this.supportsFailover;
    }
}

