/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.journal.IOCriticalErrorListener;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.TimedBuffer;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.HornetQThreadFactory;

public abstract class AbstractSequentialFileFactory
implements SequentialFileFactory {
    protected static final int EXECUTOR_TIMEOUT = 60;
    private static final Logger log = Logger.getLogger(AbstractSequentialFileFactory.class);
    protected final String journalDir;
    protected final TimedBuffer timedBuffer;
    protected final int bufferSize;
    protected final long bufferTimeout;
    private final IOCriticalErrorListener critialErrorListener;
    protected ExecutorService writeExecutor;

    public AbstractSequentialFileFactory(String journalDir, boolean buffered, int bufferSize, int bufferTimeout, boolean logRates, IOCriticalErrorListener criticalErrorListener) {
        this.journalDir = journalDir;
        this.timedBuffer = buffered ? new TimedBuffer(bufferSize, bufferTimeout, logRates) : null;
        this.bufferSize = bufferSize;
        this.bufferTimeout = bufferTimeout;
        this.critialErrorListener = criticalErrorListener;
    }

    @Override
    public void stop() {
        if (this.timedBuffer != null) {
            this.timedBuffer.stop();
        }
        if (this.isSupportsCallbacks() && this.writeExecutor != null) {
            this.writeExecutor.shutdown();
            try {
                if (!this.writeExecutor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    log.warn("Timed out on AIO writer shutdown", new Exception("Timed out on AIO writer shutdown"));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDirectory() {
        return this.journalDir;
    }

    @Override
    public void start() {
        if (this.timedBuffer != null) {
            this.timedBuffer.start();
        }
        if (this.isSupportsCallbacks()) {
            this.writeExecutor = Executors.newSingleThreadExecutor(new HornetQThreadFactory("HornetQ-Asynchronous-Persistent-Writes" + System.identityHashCode(this), true, AbstractSequentialFileFactory.getThisClassLoader()));
        }
    }

    @Override
    public void onIOError(int errorCode, String message, SequentialFile file) {
        if (this.critialErrorListener != null) {
            this.critialErrorListener.onIOException(errorCode, message, file);
        }
    }

    @Override
    public void activateBuffer(SequentialFile file) {
        if (this.timedBuffer != null) {
            file.setTimedBuffer(this.timedBuffer);
        }
    }

    @Override
    public void flush() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
        }
    }

    @Override
    public void deactivateBuffer() {
        if (this.timedBuffer != null) {
            this.timedBuffer.flush();
            this.timedBuffer.setObserver(null);
        }
    }

    @Override
    public void releaseBuffer(ByteBuffer buffer) {
    }

    @Override
    public void createDirs() throws Exception {
        File file = new File(this.journalDir);
        boolean ok = file.mkdirs();
        if (!ok) {
            throw new IOException("Failed to create directory " + this.journalDir);
        }
    }

    @Override
    public List<String> listFiles(final String extension) throws Exception {
        File dir = new File(this.journalDir);
        FilenameFilter fnf = new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith("." + extension);
            }
        };
        String[] fileNames = dir.list(fnf);
        if (fileNames == null) {
            throw new IOException("Failed to list: " + this.journalDir);
        }
        return Arrays.asList(fileNames);
    }

    private static ClassLoader getThisClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClientSessionFactoryImpl.class.getClassLoader();
            }
        });
    }
}

