/**
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.guvnor.server;

import org.drools.guvnor.server.repository.MailboxService;
import org.drools.guvnor.server.util.TestEnvironmentSessionHelper;
import org.junit.After;
import org.junit.Test;

public class ServletWrapperTest {

	@Test
	public void testMainService() {
		RepositoryServiceServlet serv = new RepositoryServiceServlet();
		serv.listPackages();
	}

	@Test
	public void testSecurityService() {
		SecurityServiceServlet serv = new SecurityServiceServlet();
		serv.getCurrentUser();
	}
	
	@After
    public void tearDown() throws Exception {
		MailboxService.getInstance().stop();
        TestEnvironmentSessionHelper.shutdown();
    }

}
