/**
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.eclipse.dsl.editor;

import java.util.HashSet;
import java.util.Set;

import org.drools.lang.dsl.DefaultDSLMapping;

/**
 * This extends the compilers DSL grammar implementation to provide
 * change listener support.
 * 
 * @author Michael Neale
 *
 */
public class NLGrammarModel extends DefaultDSLMapping {
    
    private static final long serialVersionUID = 510l;
    
    private Set changeListeners = new HashSet();

    /**
     * @param viewer
     */
    public void removeChangeListener(IMappingListViewer viewer) {
        changeListeners.remove(viewer);
    }

    /**
     * @param viewer
     */
    public void addChangeListener(IMappingListViewer viewer) {
        changeListeners.add(viewer);
    }
    
}
