/**
 * Copyright 2010 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.spi;

import java.io.Serializable;
import java.util.Iterator;

import org.drools.rule.Declaration;
import org.drools.WorkingMemory;

public interface DataProvider
    extends
    Serializable,
    Cloneable {

    public Declaration[] getRequiredDeclarations();

    public Object createContext();

    public Iterator getResults(Tuple tuple,
                               WorkingMemory wm,
                               PropagationContext ctx,
                               Object providerContext);

    public DataProvider clone();

    public void replaceDeclaration(Declaration declaration,
                                   Declaration resolved);

}
