/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logicalcobwebs.proxool.ConnectionPool;
import org.logicalcobwebs.proxool.ConnectionPoolDefinition;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;

class ConnectionPoolManager {
    private static final Object LOCK = new Object();
    private Map connectionPoolMap = new HashMap();
    private Set connectionPools = new HashSet();
    private static ConnectionPoolManager connectionPoolManager = null;
    private static final Log LOG = LogFactory.getLog(ProxoolFacade.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionPoolManager getInstance() {
        if (connectionPoolManager == null) {
            Object object = LOCK;
            synchronized (object) {
                if (connectionPoolManager == null) {
                    connectionPoolManager = new ConnectionPoolManager();
                }
            }
        }
        return connectionPoolManager;
    }

    private ConnectionPoolManager() {
    }

    protected ConnectionPool getConnectionPool(String alias) throws ProxoolException {
        ConnectionPool cp = (ConnectionPool)this.connectionPoolMap.get(alias);
        if (cp == null) {
            throw new ProxoolException(this.getKnownPools(alias));
        }
        return cp;
    }

    protected String getKnownPools(String alias) {
        StringBuffer message = new StringBuffer("Couldn't find a pool called '" + alias + "'. Known pools are: ");
        Iterator i = this.connectionPoolMap.keySet().iterator();
        while (i.hasNext()) {
            message.append((String)i.next());
            message.append(i.hasNext() ? ", " : ".");
        }
        return message.toString();
    }

    protected boolean isPoolExists(String alias) {
        return this.connectionPoolMap.containsKey(alias);
    }

    protected ConnectionPool[] getConnectionPools() {
        return this.connectionPools.toArray(new ConnectionPool[this.connectionPools.size()]);
    }

    protected ConnectionPool createConnectionPool(ConnectionPoolDefinition connectionPoolDefinition) throws ProxoolException {
        ConnectionPool connectionPool = new ConnectionPool(connectionPoolDefinition);
        this.connectionPools.add(connectionPool);
        this.connectionPoolMap.put(connectionPoolDefinition.getAlias(), connectionPool);
        return connectionPool;
    }

    protected void removeConnectionPool(String name) {
        ConnectionPool cp = (ConnectionPool)this.connectionPoolMap.get(name);
        if (cp != null) {
            this.connectionPoolMap.remove(cp.getDefinition().getAlias());
            this.connectionPools.remove(cp);
        } else {
            LOG.info((Object)("Ignored attempt to remove either non-existent or already removed connection pool " + name));
        }
    }

    public String[] getConnectionPoolNames() {
        return this.connectionPoolMap.keySet().toArray(new String[this.connectionPoolMap.size()]);
    }
}

