/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.blocks.BasicConnectionTable;
import org.jgroups.blocks.ConnectionTable;
import org.jgroups.blocks.ConnectionTableNIO;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Util;

public class ConnectionTableTest
extends TestCase {
    private BasicConnectionTable ct1;
    private BasicConnectionTable ct2;
    static InetAddress loopback_addr = null;
    static byte[] data = new byte[]{98, 101, 108, 97};
    Address addr1;
    Address addr2;
    int active_threads = 0;

    public ConnectionTableTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.active_threads = Thread.activeCount();
        System.out.println("active threads before (" + this.active_threads + "):\n" + Util.activeThreads());
        this.addr1 = new IpAddress(loopback_addr, 7500);
        this.addr2 = new IpAddress(loopback_addr, 8000);
    }

    protected void tearDown() throws Exception {
        if (this.ct2 != null) {
            this.ct2.stop();
            this.ct2 = null;
        }
        if (this.ct1 != null) {
            this.ct1.stop();
            this.ct1 = null;
        }
        super.tearDown();
    }

    public void testBlockingQueue() {
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        Thread taker = new Thread(){

            public void run() {
                try {
                    System.out.println("taking an element from the queue");
                    queue.take();
                    System.out.println("clear");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        taker.start();
        Util.sleep(500L);
        queue.clear();
        Util.interruptAndWaitToDie(taker);
        ConnectionTableTest.assertFalse((String)("taker: " + taker), (boolean)taker.isAlive());
    }

    public void testStopConnectionTableNoSendQueues() throws Exception {
        this.ct1 = new ConnectionTable(new DummyReceiver(), loopback_addr, null, 7500, 7500, 60000L, 120000L);
        this.ct1.setUseSendQueues(false);
        this.ct2 = new ConnectionTable(new DummyReceiver(), loopback_addr, null, 8000, 8000, 60000L, 120000L);
        this.ct2.setUseSendQueues(false);
        this._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionTableWithSendQueues() throws Exception {
        this.ct1 = new ConnectionTable(new DummyReceiver(), loopback_addr, null, 7500, 7500, 60000L, 120000L);
        this.ct2 = new ConnectionTable(new DummyReceiver(), loopback_addr, null, 8000, 8000, 60000L, 120000L);
        this._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionTableNIONoSendQueues() throws Exception {
        this.ct1 = new ConnectionTableNIO(new DummyReceiver(), loopback_addr, null, 7500, 7500, 60000L, 120000L, false);
        this.ct1.setUseSendQueues(false);
        this.ct2 = new ConnectionTableNIO(new DummyReceiver(), loopback_addr, null, 8000, 8000, 60000L, 120000L, false);
        this.ct2.setUseSendQueues(false);
        this.ct1.start();
        this.ct2.start();
        this._testStop(this.ct1, this.ct2);
    }

    public void testStopConnectionTableNIOWithSendQueues() throws Exception {
        this.ct1 = new ConnectionTableNIO(new DummyReceiver(), loopback_addr, null, 7500, 7500, 60000L, 120000L, false);
        this.ct2 = new ConnectionTableNIO(new DummyReceiver(), loopback_addr, null, 8000, 8000, 60000L, 120000L, false);
        this.ct1.start();
        this.ct2.start();
        this._testStop(this.ct1, this.ct2);
    }

    private void _testStop(BasicConnectionTable table1, BasicConnectionTable table2) throws Exception {
        table1.send(this.addr1, data, 0, data.length);
        ConnectionTableTest.assertEquals((int)0, (int)table1.getNumConnections());
        table1.send(this.addr2, data, 0, data.length);
        table2.send(this.addr2, data, 0, data.length);
        table2.send(this.addr1, data, 0, data.length);
        System.out.println("table1:\n" + table1 + "\ntable2:\n" + table2);
        ConnectionTableTest.assertEquals((int)1, (int)table1.getNumConnections());
        ConnectionTableTest.assertEquals((int)1, (int)table2.getNumConnections());
        table2.stop();
        table1.stop();
        ConnectionTableTest.assertEquals((int)0, (int)table1.getNumConnections());
        ConnectionTableTest.assertEquals((int)0, (int)table2.getNumConnections());
        int current_active_threads = Thread.activeCount();
        System.out.println("active threads after (" + current_active_threads + "):\n" + Util.activeThreads());
        ConnectionTableTest.assertEquals((String)("threads:\n" + Util.dumpThreads()), (int)this.active_threads, (int)current_active_threads);
    }

    public static Test suite() {
        return new TestSuite(ConnectionTableTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ConnectionTableTest.suite());
    }

    static {
        try {
            loopback_addr = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    static class DummyReceiverNIO
    implements BasicConnectionTable.Receiver {
        DummyReceiverNIO() {
        }

        public void receive(Address sender, byte[] data, int offset, int length) {
            System.out.println("-- received " + length + " bytes from " + sender);
        }
    }

    static class DummyReceiver
    implements BasicConnectionTable.Receiver {
        DummyReceiver() {
        }

        public void receive(Address sender, byte[] data, int offset, int length) {
            System.out.println("-- received " + length + " bytes from " + sender);
        }
    }
}

