/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.h2.util.StringUtils;

public class MultiDimension {
    private static MultiDimension instance = new MultiDimension();

    private MultiDimension() {
    }

    public static MultiDimension getInstance() {
        return instance;
    }

    public long interleave(int[] nArray) {
        long l;
        int n = nArray.length;
        int n2 = 64 / n;
        long l2 = 1L << n2;
        long l3 = 0L;
        for (int i = 0; i < n; ++i) {
            long l4 = nArray[i];
            if (l4 < 0L || l4 > l2) {
                throw new Error("value out of range; value=" + nArray[i] + " min=0 max=" + l2);
            }
            for (int j = 0; j < n2; ++j) {
                l3 |= (l4 & 1L << j) << i + (n - 1) * j;
            }
        }
        if (n == 2 && (l = this.getMorton2(nArray[0], nArray[1])) != l3) {
            throw new Error("test");
        }
        return l3;
    }

    public int deinterleave(long l, int n, int n2) {
        int n3 = 64 / n;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            n4 = (int)((long)n4 | l >> n2 + (n - 1) * i & 1L << i);
        }
        return n4;
    }

    public String generatePreparedQuery(String string, String string2, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("SELECT D.* FROM ");
        stringBuffer.append(StringUtils.quoteIdentifier(string));
        stringBuffer.append(" D, TABLE(_FROM_ BIGINT=?, _TO_ BIGINT=?) WHERE ");
        stringBuffer.append(StringUtils.quoteIdentifier(string2));
        stringBuffer.append(" BETWEEN _FROM_ AND _TO_");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" AND ");
            stringBuffer.append(StringUtils.quoteIdentifier(stringArray[i]));
            stringBuffer.append("+1 BETWEEN ?+1 AND ?+1");
        }
        return stringBuffer.toString();
    }

    public ResultSet getResult(PreparedStatement preparedStatement, int[] nArray, int[] nArray2) throws SQLException {
        int n;
        long[][] lArray = this.getMortonRanges(nArray, nArray2);
        int n2 = lArray.length;
        Long[] longArray = new Long[n2];
        Long[] longArray2 = new Long[n2];
        for (n = 0; n < n2; ++n) {
            longArray[n] = new Long(lArray[n][0]);
            longArray2[n] = new Long(lArray[n][1]);
        }
        preparedStatement.setObject(1, longArray);
        preparedStatement.setObject(2, longArray2);
        n2 = nArray.length;
        int n3 = 3;
        for (n = 0; n < n2; ++n) {
            preparedStatement.setInt(n3++, nArray[n]);
            preparedStatement.setInt(n3++, nArray2[n]);
        }
        return preparedStatement.executeQuery();
    }

    public String generateQuery(String string, String string2, String[] stringArray, int[] nArray, int[] nArray2) {
        int n;
        long[][] lArray = this.getMortonRanges(nArray, nArray2);
        StringBuffer stringBuffer = new StringBuffer("SELECT * FROM (");
        for (n = 0; n < lArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(" UNION ALL ");
            }
            long l = lArray[n][0];
            long l2 = lArray[n][1];
            stringBuffer.append("SELECT * FROM ").append(string).append(" WHERE ");
            stringBuffer.append(string2).append(" BETWEEN ");
            stringBuffer.append(l).append(" AND ").append(l2);
        }
        stringBuffer.append(") WHERE ");
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(stringArray[n]).append(" BETWEEN ");
            stringBuffer.append(nArray[n]).append(" AND ").append(nArray2[n]);
        }
        return stringBuffer.toString();
    }

    public long[][] getMortonRanges(int[] nArray, int[] nArray2) {
        int n;
        int n2 = nArray.length;
        if (nArray2.length != n2) {
            throw new Error("dimensions mismatch");
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] <= nArray2[n]) continue;
            int n3 = nArray[n];
            nArray[n] = nArray2[n];
            nArray2[n] = n3;
        }
        n = this.getSize(nArray, nArray2, n2);
        ArrayList arrayList = new ArrayList();
        this.addMortonRanges(arrayList, nArray, nArray2, n2, 0);
        this.optimize(arrayList, n);
        long[][] lArray = new long[arrayList.size()][2];
        arrayList.toArray((T[])lArray);
        return lArray;
    }

    private long getMorton2(int n, int n2) {
        long l = 0L;
        for (int i = 0; i < 32; ++i) {
            l |= ((long)n & 1L << i) << i;
            l |= ((long)n2 & 1L << i) << i + 1;
        }
        return l;
    }

    private int getSize(int[] nArray, int[] nArray2, int n) {
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray2[i] - nArray[i];
            n2 *= n3 + 1;
        }
        return n2;
    }

    private void optimize(ArrayList arrayList, int n) {
        Collections.sort(arrayList, new Comparator(){

            public int compare(Object object, Object object2) {
                long[] lArray = (long[])object;
                long[] lArray2 = (long[])object2;
                return lArray[0] > lArray2[0] ? 1 : -1;
            }
        });
        int n2 = 10;
        while (true) {
            long[] lArray;
            int n3;
            for (n3 = 0; n3 < arrayList.size() - 1; ++n3) {
                long[] lArray2 = (long[])arrayList.get(n3);
                if (lArray2[1] + (long)n2 < (lArray = (long[])arrayList.get(n3 + 1))[0]) continue;
                lArray2[1] = lArray[1];
                arrayList.remove(n3 + 1);
                --n3;
            }
            n3 = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                lArray = (long[])arrayList.get(i);
                n3 = (int)((long)n3 + (lArray[1] - lArray[0] + 1L));
            }
            if (n3 > 2 * n || arrayList.size() < 3) break;
            n2 += n2 / 2;
        }
    }

    private void addMortonRanges(ArrayList arrayList, int[] nArray, int[] nArray2, int n, int n2) {
        if (n2 > 100) {
            throw new Error("Stop");
        }
        int n3 = 0;
        int n4 = 0;
        long l = 1L;
        for (int i = 0; i < n; ++i) {
            int n5 = nArray2[i] - nArray[i];
            if (n5 < 0) {
                throw new Error("Stop");
            }
            if ((l *= (long)(n5 + 1)) < 0L) {
                throw new Error("Stop");
            }
            if (n5 <= n4) continue;
            n4 = n5;
            n3 = i;
        }
        long l2 = this.interleave(nArray);
        long l3 = this.interleave(nArray2);
        if (l3 < l2) {
            throw new Error("Stop");
        }
        long l4 = l3 - l2 + 1L;
        if (l4 == l) {
            long[] lArray = new long[]{l2, l3};
            arrayList.add(lArray);
        } else {
            int n6 = this.findMiddle(nArray[n3], nArray2[n3]);
            int n7 = nArray2[n3];
            nArray2[n3] = n6;
            this.addMortonRanges(arrayList, nArray, nArray2, n, n2 + 1);
            nArray2[n3] = n7;
            n7 = nArray[n3];
            nArray[n3] = n6 + 1;
            this.addMortonRanges(arrayList, nArray, nArray2, n, n2 + 1);
            nArray[n3] = n7;
        }
    }

    private int roundUp(int n, int n2) {
        return n + n2 - 1 & -n2;
    }

    private int findMiddle(int n, int n2) {
        int n3;
        int n4 = n2 - n - 1;
        if (n4 == 0) {
            return n;
        }
        if (n4 == 1) {
            return n + 1;
        }
        int n5 = 0;
        while (1 << n5 < n4) {
            ++n5;
        }
        if ((n3 = this.roundUp(n + 2, 1 << --n5) - 1) <= n || n3 >= n2) {
            throw new Error("stop");
        }
        return n3;
    }
}

