/*
 * Decompiled with CFR 0.152.
 */
package org.h2.log;

import java.sql.SQLException;
import org.h2.log.LogFile;
import org.h2.message.Message;

public class InDoubtTransaction {
    public static final int IN_DOUBT = 0;
    public static final int COMMIT = 1;
    public static final int ROLLBACK = 2;
    private LogFile log;
    private int sessionId;
    private int pos;
    private String transaction;
    private int blocks;
    private int state;

    public InDoubtTransaction(LogFile logFile, int n, int n2, String string, int n3) {
        this.log = logFile;
        this.sessionId = n;
        this.pos = n2;
        this.transaction = string;
        this.blocks = n3;
        this.state = 0;
    }

    public void setState(int n) throws SQLException {
        switch (n) {
            case 1: {
                this.log.updatePreparedCommit(true, this.pos, this.sessionId, this.blocks);
                break;
            }
            case 2: {
                this.log.updatePreparedCommit(false, this.pos, this.sessionId, this.blocks);
                break;
            }
            default: {
                throw Message.getInternalError("state=" + n);
            }
        }
        this.state = n;
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return "IN_DOUBT";
            }
            case 1: {
                return "COMMIT";
            }
            case 2: {
                return "ROLLBACK";
            }
        }
        throw Message.getInternalError("state=" + this.state);
    }

    public int getPos() {
        return this.pos;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public String getTransaction() {
        return this.transaction;
    }
}

