/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.index.IndexCondition;
import org.h2.message.Message;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class ValueExpression
extends Expression {
    private Value value;
    public static final ValueExpression NULL = new ValueExpression(ValueNull.INSTANCE);
    public static final ValueExpression DEFAULT = new ValueExpression(ValueNull.INSTANCE);

    public static ValueExpression get(Value value) {
        if (value == ValueNull.INSTANCE) {
            return NULL;
        }
        return new ValueExpression(value);
    }

    private ValueExpression(Value value) {
        this.value = value;
    }

    public Value getValue(Session session) {
        return this.value;
    }

    public int getType() {
        return this.value.getType();
    }

    public void createIndexConditions(Session session, TableFilter tableFilter) {
        boolean bl;
        if (this.value.getType() == 1 && !(bl = ((ValueBoolean)this.value).getBoolean().booleanValue())) {
            tableFilter.addIndexCondition(new IndexCondition(8, null, this));
        }
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }

    public void mapColumns(ColumnResolver columnResolver, int n) throws SQLException {
    }

    public Expression optimize(Session session) throws SQLException {
        return this;
    }

    public boolean isConstant() {
        return true;
    }

    public boolean isValueSet() {
        return true;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    public int getScale() {
        return this.value.getScale();
    }

    public long getPrecision() {
        return this.value.getPrecision();
    }

    public int getDisplaySize() {
        return this.value.getDisplaySize();
    }

    public String getSQL() {
        if (this == DEFAULT) {
            return "DEFAULT";
        }
        return this.value.getSQL();
    }

    public void updateAggregate(Session session) throws SQLException {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.type) {
            case 1: {
                return true;
            }
            case 2: 
            case 5: {
                return true;
            }
            case 0: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        throw Message.getInternalError("type=" + expressionVisitor.type);
    }

    public int getCost() {
        return 0;
    }
}

