/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public abstract class DbObjectBase
implements DbObject {
    protected Database database;
    protected Trace trace;
    protected String comment;
    private int id;
    private String objectName;
    private long modificationId;
    private boolean temporary;

    protected void initDbObjectBase(Database database, int n, String string, String string2) {
        this.database = database;
        this.trace = database.getTrace(string2);
        this.id = n;
        this.objectName = string;
        this.modificationId = database.getModificationMetaId();
    }

    public abstract String getCreateSQLForCopy(Table var1, String var2);

    public abstract String getCreateSQL();

    public abstract String getDropSQL();

    public abstract int getType();

    public abstract void removeChildrenAndResources(Session var1) throws SQLException;

    public abstract void checkRename() throws SQLException;

    public void setModified() {
        this.modificationId = this.database == null ? -1L : this.database.getNextModificationMetaId();
    }

    public long getModificationId() {
        return this.modificationId;
    }

    protected void setObjectName(String string) {
        this.objectName = string;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.objectName);
    }

    public ObjectArray getChildren() {
        return null;
    }

    public Database getDatabase() {
        return this.database;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.objectName;
    }

    protected void invalidate() {
        this.setModified();
        this.id = -1;
        this.database = null;
        this.trace = null;
        this.objectName = null;
    }

    public int getHeadPos() {
        return 0;
    }

    public void rename(String string) throws SQLException {
        this.checkRename();
        this.objectName = string;
        this.setModified();
    }

    public boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean bl) {
        this.temporary = bl;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    static int getCreateOrder(int n) {
        switch (n) {
            case 6: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 12: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 11: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 14;
            }
        }
        throw Message.getInternalError("type=" + n);
    }
}

