/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.sql.SQLException;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.result.LocalResult;
import org.h2.util.ObjectArray;
import org.h2.value.Value;

public class CommandContainer
extends Command {
    private Prepared prepared;

    CommandContainer(Parser parser, String string, Prepared prepared) {
        super(parser, string);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    public ObjectArray getParameters() {
        return this.prepared.getParameters();
    }

    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() throws SQLException {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string = this.prepared.getSQL();
            ObjectArray objectArray = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parseOnly(string);
            long l = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ObjectArray objectArray2 = this.prepared.getParameters();
            for (int i = 0; i < objectArray2.size(); ++i) {
                Value value = ((Expression)objectArray.get(i)).getValue(this.session);
                Parameter parameter = (Parameter)objectArray2.get(i);
                parameter.setValue(value);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l);
        }
    }

    public int update() throws SQLException {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        int n = this.prepared.update();
        this.prepared.trace(this.startTime, n);
        return n;
    }

    public LocalResult query(int n) throws SQLException {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        LocalResult localResult = this.prepared.query(n);
        this.prepared.trace(this.startTime, localResult.getRowCount());
        return localResult;
    }

    public boolean isReadOnly() {
        return this.prepared.isReadOnly();
    }

    public LocalResult queryMeta() throws SQLException {
        return this.prepared.queryMeta();
    }
}

