/*
 * Decompiled with CFR 0.152.
 */
package org.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.message.TraceSystem;

public class Driver
implements java.sql.Driver {
    private static final Driver INSTANCE = new Driver();

    public Connection connect(String string, Properties properties) throws SQLException {
        try {
            if (properties == null) {
                properties = new Properties();
            }
            if (!this.acceptsURL(string)) {
                return null;
            }
            return new JdbcConnection(string, properties);
        }
        catch (Throwable throwable) {
            throw Message.convert(throwable);
        }
    }

    public boolean acceptsURL(String string) {
        return string != null && string.startsWith("jdbc:h2:");
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public static Driver load() {
        return INSTANCE;
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException sQLException) {
            TraceSystem.traceThrowable(sQLException);
        }
    }
}

