/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf.transports;

import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.InitialContext;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;

public class JmsTransport
implements Transport,
MessageListener {
    Receiver receiver = null;
    Properties config = null;
    Object local_addr = null;
    ConnectionFactory factory;
    InitialContext ctx;
    TopicConnection conn;
    TopicSession session;
    TopicPublisher pub;
    TopicSubscriber sub;
    Topic topic;
    String topic_name = "topic/testTopic";

    public Object getLocalAddress() {
        return this.local_addr;
    }

    public void create(Properties properties) throws Exception {
        this.config = properties;
        String tmp = this.config.getProperty("topic");
        if (tmp != null) {
            this.topic_name = tmp;
        }
        this.ctx = new InitialContext();
        this.factory = (ConnectionFactory)this.ctx.lookup("ConnectionFactory");
        System.out.println("-- local_addr is " + this.local_addr);
    }

    public void start() throws Exception {
        this.local_addr = this.conn.getClientID();
        this.conn = ((TopicConnectionFactory)this.factory).createTopicConnection();
        this.session = this.conn.createTopicSession(false, 1);
        this.topic = (Topic)this.ctx.lookup(this.topic_name);
        this.pub = this.session.createPublisher(this.topic);
        this.sub = this.session.createSubscriber(this.topic);
        this.sub.setMessageListener((MessageListener)this);
        this.conn.start();
    }

    public void stop() {
        try {
            this.conn.stop();
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }

    public void destroy() {
    }

    public void setReceiver(Receiver r) {
        this.receiver = r;
    }

    public void send(Object destination, byte[] payload) throws Exception {
        if (destination != null) {
            throw new Exception("JmsTransport.send(): unicast destination is not supported");
        }
        BytesMessage msg = this.session.createBytesMessage();
        msg.writeInt(payload.length);
        msg.writeBytes(payload, 0, payload.length);
        this.pub.publish(this.topic, (Message)msg);
    }

    public void onMessage(Message message) {
        Object sender = null;
        if (message == null || !(message instanceof BytesMessage)) {
            System.err.println("JmsTransport.onMessage(): received a non BytesMessage (" + message + "), discarding");
            return;
        }
        BytesMessage msg = (BytesMessage)message;
        try {
            int len = msg.readInt();
            byte[] payload = new byte[len];
            msg.readBytes(payload, len);
            if (this.receiver != null) {
                this.receiver.receive(sender, payload);
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

