/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.adaptjms;

import java.io.Serializable;
import java.util.List;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.log4j.Logger;
import org.jgroups.tests.adaptjms.Request;

public class SenderThread
extends Thread {
    private int num_msgs;
    private int msg_size;
    Logger log = Logger.getLogger(this.getClass());
    long log_interval = 1000L;
    boolean gnuplot_output = Boolean.getBoolean("gnuplot_output");
    List nodes;
    TopicPublisher pub;
    TopicSession session;
    Topic topic;

    public SenderThread(TopicSession session, TopicPublisher pub, Topic topic, int num_msgs, int ms, long log_interval) {
        this.num_msgs = num_msgs;
        this.msg_size = ms;
        this.log_interval = log_interval;
        this.session = session;
        this.pub = pub;
        this.topic = topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long total_msgs = 0L;
        System.out.println("Sender thread started...");
        try {
            byte[] m = new byte[this.msg_size];
            for (int h = 0; h < this.msg_size; ++h) {
                m[h] = (byte)h;
            }
            System.out.println("Everyone joined, ready to begin test...\n");
            for (int i = 0; i < this.num_msgs; ++i) {
                Request req = new Request(3, m);
                ObjectMessage msg = this.session.createObjectMessage((Serializable)req);
                this.pub.publish(this.topic, (Message)msg);
                if (++total_msgs % 1000L == 0L) {
                    System.out.println("++ sent " + total_msgs);
                }
                if (total_msgs % this.log_interval != 0L || this.gnuplot_output || !this.log.isInfoEnabled()) continue;
                this.log.info((Object)this.dumpStats(total_msgs));
            }
            System.out.println("Sent all bursts. Sender terminates.\n");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String dumpStats(long sent_msgs) {
        StringBuffer sb = new StringBuffer();
        sb.append("\nmsgs_sent=").append(sent_msgs).append('\n');
        sb.append("free_mem=").append(Runtime.getRuntime().freeMemory());
        sb.append(" (total_mem=").append(Runtime.getRuntime().totalMemory()).append(")\n");
        return sb.toString();
    }
}

