/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Message;

public class AckReceiverWindow {
    final long initial_seqno;
    long next_to_remove = 0L;
    final HashMap msgs = new HashMap();
    static final Log log = LogFactory.getLog((Class)AckReceiverWindow.class);

    public AckReceiverWindow(long initial_seqno) {
        this.initial_seqno = initial_seqno;
        this.next_to_remove = initial_seqno;
    }

    public void add(long seqno, Message msg) {
        if (seqno < this.next_to_remove) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("discarded msg with seqno=" + seqno + " (next msg to receive is " + this.next_to_remove + ')'));
            }
            return;
        }
        this.msgs.put(new Long(seqno), msg);
    }

    public Message remove() {
        Message retval = (Message)this.msgs.remove(new Long(this.next_to_remove));
        if (retval != null) {
            ++this.next_to_remove;
        }
        return retval;
    }

    public void reset() {
        this.msgs.clear();
        this.next_to_remove = this.initial_seqno;
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        return this.msgs.keySet().toString();
    }
}

