/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.ring;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.protocols.ring.RingToken;

public class RingNodeFlowControl {
    final int initialWindow;
    final float windowReduceFactor;
    final int belowThresholdAdvanceAmount;
    final float aboveThresholdAdvanceAmount;
    private int memberCount;
    private int previousBacklog;
    private int backlog;
    protected final Log log = LogFactory.getLog(this.getClass());

    public RingNodeFlowControl(int initialWindow, float windowReduceFactor, int belowThresholdAdvanceAmount, float aboveThresholdAdvanceAmount) {
        this.initialWindow = initialWindow;
        this.windowReduceFactor = windowReduceFactor;
        this.belowThresholdAdvanceAmount = belowThresholdAdvanceAmount;
        this.aboveThresholdAdvanceAmount = aboveThresholdAdvanceAmount;
    }

    public RingNodeFlowControl() {
        this(20, 0.7f, 3, 1.0f);
    }

    public void invalidate() {
        this.backlog = 0;
        this.previousBacklog = 0;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        if (backlog < 0) {
            throw new IllegalArgumentException("backlog value has to be positive");
        }
        this.backlog = backlog;
    }

    public int getBacklogDifference() {
        return this.backlog - this.previousBacklog;
    }

    public int getPreviousBacklog() {
        return this.previousBacklog;
    }

    public void setPreviousBacklog() {
        this.previousBacklog = this.backlog;
    }

    public void viewChanged(int memberCount) {
        this.memberCount = memberCount;
    }

    public int getAllowedToBroadcast(RingToken token) {
        int backlogAverage;
        int maxMessages;
        int fairWindowShare = 0;
        int windowSize = token.getWindowSize();
        if (this.memberCount == 0) {
            this.memberCount = 1;
        }
        if ((maxMessages = windowSize / this.memberCount) < 1) {
            maxMessages = 1;
        }
        if ((backlogAverage = token.getBacklog() + this.backlog - this.previousBacklog) > 0) {
            fairWindowShare = windowSize * this.backlog / backlogAverage;
        }
        fairWindowShare = fairWindowShare < 1 ? 1 : fairWindowShare;
        int maxAllowed = windowSize - token.getLastRoundBroadcastCount();
        if (maxAllowed < 1) {
            maxAllowed = 0;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("fairWindowShare=" + fairWindowShare + " maxMessages=" + maxMessages + " maxAllowed=" + maxAllowed));
        }
        return fairWindowShare < maxAllowed ? Math.min(fairWindowShare, maxMessages) : Math.min(maxAllowed, maxMessages);
    }

    public void updateWindow(RingToken token) {
        boolean congested;
        int threshold = token.getWindowThreshold();
        int window = token.getWindowSize();
        if (window < this.initialWindow) {
            window = this.initialWindow;
        }
        boolean bl = congested = token.getRetransmissionRequests().size() > 0;
        if (congested) {
            threshold = (int)((float)window * this.windowReduceFactor);
            window = this.initialWindow;
        } else {
            window = window < threshold ? (window += this.belowThresholdAdvanceAmount) : (int)((float)window + this.aboveThresholdAdvanceAmount);
        }
        token.setWindowSize(window);
        token.setWindowThreshold(threshold);
    }
}

