/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.weaving.adaptors.AspectJAdaptor;
import org.eclipse.equinox.weaving.adaptors.AspectJAdaptorFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IAspectJAdaptor;
import org.eclipse.equinox.weaving.hooks.AbstractAspectJHook;
import org.eclipse.equinox.weaving.hooks.AspectJBundleEntry;
import org.eclipse.equinox.weaving.hooks.AspectJBundleFile;
import org.eclipse.equinox.weaving.hooks.BaseAjBundleFile;
import org.eclipse.equinox.weaving.hooks.BundleAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.SupplementBundleListener;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class AspectJHook
extends AbstractAspectJHook {
    private final AspectJAdaptorFactory adaptorFactory;
    private final Map<Long, IAspectJAdaptor> adaptors;
    private BundleContext bundleContext;

    public AspectJHook() {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.<init>()");
        }
        this.adaptorFactory = new AspectJAdaptorFactory();
        this.adaptors = new HashMap<Long, IAspectJAdaptor>();
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        this.initialize(context);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.adaptorFactory.dispose(context);
    }

    public IAspectJAdaptor getAdaptor(long bundleID) {
        return this.adaptors.get(bundleID);
    }

    public IAspectJAdaptor getHostBundleAdaptor(long bundleID) {
        Bundle host;
        Bundle bundle = this.bundleContext.getBundle(bundleID);
        if (bundle != null && (host = this.adaptorFactory.getHost(bundle)) != null) {
            long hostBundleID = host.getBundleId();
            return this.adaptors.get(hostBundleID);
        }
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initializedClassLoader() bundle=" + data.getSymbolicName() + ", loader=" + baseClassLoader + ", data=" + data + ", bundleFile=" + data.getBundleFile());
        }
        IAspectJAdaptor adaptor = this.createAspectJAdaptor(data);
        adaptor.setBaseClassLoader(baseClassLoader);
        adaptor.initialize();
        this.adaptors.put(data.getBundleID(), adaptor);
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initializedClassLoader() adaptor=" + adaptor);
        }
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        AspectJBundleEntry ajBundleEntry;
        byte[] newClassytes = null;
        if (entry instanceof AspectJBundleEntry && !(ajBundleEntry = (AspectJBundleEntry)entry).dontWeave()) {
            IAspectJAdaptor adaptor = ajBundleEntry.getAdaptor();
            newClassytes = adaptor.weaveClass(name, classbytes);
        }
        return newClassytes;
    }

    public void recordClassDefine(String name, Class clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        AspectJBundleEntry ajBundleEntry;
        if (entry instanceof AspectJBundleEntry && !(ajBundleEntry = (AspectJBundleEntry)entry).dontWeave()) {
            IAspectJAdaptor adaptor = ajBundleEntry.getAdaptor();
            URL sourceFileURL = ajBundleEntry.getBundleFileURL();
            adaptor.storeClass(name, sourceFileURL, clazz, classbytes);
        }
    }

    public BundleFile wrapBundleFile(BundleFile bundleFile, Object content, BaseData data, boolean base) throws IOException {
        AspectJBundleFile wrapped = null;
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("> AspectJBundleFileWrapperFactoryHook.wrapBundleFile() bundle=" + data.getSymbolicName() + " bundleFile=" + bundleFile + ", content=" + content + ", data=" + data + ", base=" + base + ", baseFile=" + bundleFile.getBaseFile());
        }
        wrapped = base ? new BaseAjBundleFile(new BundleAdaptorProvider(data, this), bundleFile) : new AspectJBundleFile(new BundleAdaptorProvider(data, this), bundleFile);
        if (Debug.DEBUG_BUNDLE) {
            Debug.println("< AspectJBundleFileWrapperFactoryHook.wrapBundleFile() wrapped=" + (Object)((Object)wrapped));
        }
        return wrapped;
    }

    private IAspectJAdaptor createAspectJAdaptor(BaseData baseData) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.createAspectJAdaptor() location=" + baseData.getLocation());
        }
        AspectJAdaptor adaptor = null;
        if (this.adaptorFactory != null) {
            adaptor = new AspectJAdaptor(baseData, this.adaptorFactory, null, null, null);
        } else if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJHook.createAspectJAdaptor() factory=" + this.adaptorFactory);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.createAspectJAdaptor() adaptor=" + adaptor);
        }
        return adaptor;
    }

    private IAspectJAdaptor getAspectJAdaptor(BaseData data) {
        return this.getAdaptor(data.getBundleID());
    }

    private void initialize(BundleContext context) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJHook.initialize() context=" + context);
        }
        this.bundleContext = context;
        ISupplementerRegistry supplementerRegistry = this.getSupplementerRegistry();
        this.adaptorFactory.initialize(context, supplementerRegistry);
        ServiceReference serviceReference = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(serviceReference);
        supplementerRegistry.setBundleContext(context);
        supplementerRegistry.setPackageAdmin(packageAdmin);
        context.addBundleListener((BundleListener)new SupplementBundleListener(supplementerRegistry));
        Bundle[] installedBundles = context.getBundles();
        int i = 0;
        while (i < installedBundles.length) {
            supplementerRegistry.addSupplementer(installedBundles[i], false);
            ++i;
        }
        i = 0;
        while (i < installedBundles.length) {
            supplementerRegistry.addSupplementedBundle(installedBundles[i]);
            ++i;
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJHook.initialize() adaptorFactory=" + this.adaptorFactory);
        }
    }
}

