/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.service.weaving.IWeavingServiceFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public class AspectJAdaptorFactory {
    private static final Collection IGNORE_WEAVING_SERVICE_BUNDLES = Arrays.asList("org.eclipse.equinox.weaving.aspectj", "org.eclipse.equinox.weaving.caching", "org.eclipse.equinox.weaving.caching.j9", "org.eclipse.update.configurator", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.equinox.common");
    private static final String WEAVING_SERVICE_DYNAMICS_PROPERTY = "equinox.weaving.service.dynamics";
    private BundleContext bundleContext;
    private ServiceTracker cachingServiceFactoryTracker;
    private PackageAdmin packageAdminService;
    private StartLevel startLevelService;
    private ISupplementerRegistry supplementerRegistry;
    private ServiceTracker weavingServiceFactoryTracker;
    private ServiceListener weavingServiceListener;
    private final Map weavingServices = Collections.synchronizedMap(new HashMap());

    public void dispose(BundleContext context) {
        context.removeServiceListener(this.weavingServiceListener);
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Removed service listener for weaving service.");
        }
        this.weavingServiceFactoryTracker.close();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Closed service tracker for weaving service.");
        }
        this.cachingServiceFactoryTracker.close();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Closed service tracker for caching service.");
        }
    }

    public Bundle getHost(Bundle fragment) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.getHost() fragment=" + fragment);
        }
        Bundle host = null;
        if (this.packageAdminService != null) {
            host = this.packageAdminService.getHosts(fragment)[0];
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.getHost() " + host);
        }
        return host;
    }

    public void initialize(BundleContext context, final ISupplementerRegistry supplementerRegistry) {
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initialize() context=" + context);
        }
        this.bundleContext = context;
        this.supplementerRegistry = supplementerRegistry;
        this.initializePackageAdminService(context);
        this.initializeStartLevelService(context);
        this.weavingServiceFactoryTracker = new ServiceTracker(context, IWeavingServiceFactory.class.getName(), null);
        this.weavingServiceFactoryTracker.open();
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> Opened service tracker for weaving service.");
        }
        this.weavingServiceListener = new ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceChanged(ServiceEvent event) {
                Bundle bundle;
                Map.Entry entry;
                Map map;
                Iterator bundleEntries;
                ArrayList<Bundle> bundlesToRefresh;
                if (event.getType() == 1) {
                    bundlesToRefresh = new ArrayList<Bundle>();
                    bundleEntries = AspectJAdaptorFactory.this.weavingServices.entrySet().iterator();
                    map = AspectJAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        while (bundleEntries.hasNext()) {
                            entry = bundleEntries.next();
                            bundle = (Bundle)entry.getKey();
                            if (entry.getValue() != null) continue;
                            bundleEntries.remove();
                            System.err.println("bundle update because of weaving service start: " + bundle.getSymbolicName());
                            bundlesToRefresh.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (bundlesToRefresh.size() > 0) {
                        supplementerRegistry.refreshBundles(bundlesToRefresh.toArray(new Bundle[bundlesToRefresh.size()]));
                    }
                }
                if (event.getType() == 4 && AspectJAdaptorFactory.this.startLevelService != null && AspectJAdaptorFactory.this.startLevelService.getStartLevel() > 0) {
                    bundlesToRefresh = new ArrayList();
                    bundleEntries = AspectJAdaptorFactory.this.weavingServices.entrySet().iterator();
                    map = AspectJAdaptorFactory.this.weavingServices;
                    synchronized (map) {
                        while (bundleEntries.hasNext()) {
                            entry = bundleEntries.next();
                            bundle = (Bundle)entry.getKey();
                            if (entry.getValue() == null) continue;
                            bundleEntries.remove();
                            System.err.println("bundle update because of weaving service stop: " + bundle.getSymbolicName());
                            bundlesToRefresh.add(bundle);
                            if (!Debug.DEBUG_WEAVE) continue;
                            Debug.println("> Updated bundle " + bundle.getSymbolicName());
                        }
                    }
                    if (bundlesToRefresh.size() > 0) {
                        supplementerRegistry.refreshBundles(bundlesToRefresh.toArray(new Bundle[bundlesToRefresh.size()]));
                    }
                }
            }
        };
        if (System.getProperty(WEAVING_SERVICE_DYNAMICS_PROPERTY, "false").equals("true")) {
            try {
                context.addServiceListener(this.weavingServiceListener, "(objectClass=" + IWeavingService.class.getName() + ")");
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        this.cachingServiceFactoryTracker = new ServiceTracker(context, ICachingServiceFactory.class.getName(), null);
        this.cachingServiceFactoryTracker.open();
        if (Debug.DEBUG_CACHE) {
            Debug.println("> Opened service tracker for caching service.");
        }
    }

    protected ICachingService getCachingService(BaseClassLoader loader, Bundle bundle, IWeavingService weavingService) {
        ICachingServiceFactory cachingServiceFactory;
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptorFactory.getCachingService() bundle=" + bundle + ", weavingService=" + weavingService);
        }
        ICachingService service = null;
        String key = "";
        if (weavingService != null) {
            key = weavingService.getKey();
        }
        if ((cachingServiceFactory = (ICachingServiceFactory)this.cachingServiceFactoryTracker.getService()) != null) {
            service = cachingServiceFactory.createCachingService((ClassLoader)loader, bundle, key);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptorFactory.getCachingService() service=" + service + ", key='" + key + "'");
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IWeavingService getWeavingService(BaseClassLoader loader) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> AspectJAdaptorFactory.getWeavingService() baseClassLoader=" + loader);
        }
        BaseData baseData = loader.getClasspathManager().getBaseData();
        State state = baseData.getAdaptor().getState();
        Bundle bundle = baseData.getBundle();
        BundleDescription bundleDescription = state.getBundle(bundle.getBundleId());
        IWeavingService weavingService = null;
        if (!IGNORE_WEAVING_SERVICE_BUNDLES.contains(bundle.getSymbolicName())) {
            IWeavingServiceFactory weavingServiceFactory = (IWeavingServiceFactory)this.weavingServiceFactoryTracker.getService();
            if (weavingServiceFactory != null) {
                weavingService = weavingServiceFactory.createWeavingService((ClassLoader)loader, bundle, state, bundleDescription, this.supplementerRegistry);
            }
            Map map = this.weavingServices;
            synchronized (map) {
                this.weavingServices.put(bundle, weavingService);
            }
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< AspectJAdaptorFactory.getWeavingService() service=" + weavingService);
        }
        return weavingService;
    }

    private void initializePackageAdminService(BundleContext context) {
        ServiceReference ref;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initializePackageAdminService() context=" + context);
        }
        if ((ref = context.getServiceReference(PackageAdmin.class.getName())) != null) {
            this.packageAdminService = (PackageAdmin)context.getService(ref);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.initializePackageAdminService() " + this.packageAdminService);
        }
    }

    private void initializeStartLevelService(BundleContext context) {
        ServiceReference ref;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("> AspectJAdaptorFactory.initializeStartLevelService() context=" + context);
        }
        if ((ref = context.getServiceReference(StartLevel.class.getName())) != null) {
            this.startLevelService = (StartLevel)context.getService(ref);
        }
        if (Debug.DEBUG_GENERAL) {
            Debug.println("< AspectJAdaptorFactory.initializeStartLevelService() " + this.startLevelService);
        }
    }
}

