/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.adaptors;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.service.weaving.CacheEntry;
import org.eclipse.equinox.service.weaving.ICachingService;
import org.eclipse.equinox.service.weaving.IWeavingService;
import org.eclipse.equinox.weaving.adaptors.AspectJAdaptorFactory;
import org.eclipse.equinox.weaving.adaptors.Debug;
import org.eclipse.equinox.weaving.adaptors.IAspectJAdaptor;
import org.eclipse.equinox.weaving.hooks.AspectJBundleFile;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;

public class AspectJAdaptor
implements IAspectJAdaptor {
    private static ThreadLocalSet identifyRecursionSet = new ThreadLocalSet();
    private BaseClassLoader baseLoader;
    private Bundle bundle;
    private ICachingService cachingService;
    private final BaseData data;
    private final AspectJAdaptorFactory factory;
    private boolean initialized = false;
    private String symbolicName;
    private IWeavingService weavingService;

    public AspectJAdaptor(BaseData baseData, AspectJAdaptorFactory serviceFactory, BaseClassLoader baseClassLoader, IWeavingService weavingService, ICachingService cachingService) {
        this.data = baseData;
        this.factory = serviceFactory;
        this.symbolicName = baseData.getLocation();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJAdaptor.AspectJAdaptor() bundle=" + this.symbolicName);
        }
    }

    public CacheEntry findClass(String name, URL sourceFileURL) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptor.findClass() bundle=" + this.symbolicName + ", url=" + sourceFileURL + ", name=" + name);
        }
        CacheEntry cacheEntry = null;
        this.initialize();
        if (this.cachingService != null) {
            cacheEntry = this.cachingService.findStoredClass("", sourceFileURL, name);
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptor.findClass() cacheEntry=" + cacheEntry);
        }
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        AspectJAdaptor aspectJAdaptor = this;
        synchronized (aspectJAdaptor) {
            if (this.initialized) {
                return;
            }
            this.bundle = this.data.getBundle();
            this.symbolicName = this.data.getSymbolicName();
            if (!identifyRecursionSet.contains(this)) {
                identifyRecursionSet.put(this);
                if (Debug.DEBUG_GENERAL) {
                    Debug.println("> AspectJAdaptor.initialize() bundle=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
                }
                if (this.symbolicName.startsWith("org.aspectj")) {
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
                    }
                } else if (this.baseLoader != null) {
                    this.weavingService = this.factory.getWeavingService(this.baseLoader);
                    this.cachingService = this.factory.getCachingService(this.baseLoader, this.bundle, this.weavingService);
                } else if (this.bundle instanceof BundleFragment) {
                    BaseData hostData;
                    BundleFile bundleFile;
                    BundleFragment fragment = (BundleFragment)this.bundle;
                    BundleHost host = (BundleHost)this.factory.getHost((Bundle)fragment);
                    if (Debug.DEBUG_GENERAL) {
                        Debug.println("- AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", host=" + host);
                    }
                    if ((bundleFile = (hostData = (BaseData)host.getBundleData()).getBundleFile()) instanceof AspectJBundleFile) {
                        AspectJBundleFile hostFile = (AspectJBundleFile)bundleFile;
                        AspectJAdaptor hostAdaptor = (AspectJAdaptor)hostFile.getAdaptor();
                        this.weavingService = hostAdaptor.weavingService;
                        this.cachingService = this.factory.getCachingService(hostAdaptor.baseLoader, this.bundle, this.weavingService);
                    }
                } else if (Debug.DEBUG_GENERAL) {
                    Debug.println("W AspectJAdaptor.initialize() symbolicName=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
                }
                this.initialized = true;
                identifyRecursionSet.remove(this);
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println("< AspectJAdaptor.initialize() weavingService=" + (this.weavingService != null) + ", cachingService=" + (this.cachingService != null));
            }
        }
    }

    public void setBaseClassLoader(BaseClassLoader baseClassLoader) {
        this.baseLoader = baseClassLoader;
        if (Debug.DEBUG_GENERAL) {
            Debug.println("- AspectJAdaptor.setBaseClassLoader() bundle=" + this.symbolicName + ", baseLoader=" + this.baseLoader);
        }
    }

    public boolean storeClass(String name, URL sourceFileURL, Class clazz, byte[] classbytes) {
        if (Debug.DEBUG_CACHE) {
            Debug.println("> AspectJAdaptor.storeClass() bundle=" + this.symbolicName + ", url=" + sourceFileURL + ", name=" + name + ", clazz=" + clazz);
        }
        boolean stored = false;
        this.initialize();
        if (this.cachingService != null) {
            if (this.weavingService != null && this.weavingService.generatedClassesExistFor((ClassLoader)this.baseLoader, name)) {
                if (this.cachingService.canCacheGeneratedClasses()) {
                    Map<String, byte[]> generatedClasses = this.weavingService.getGeneratedClassesFor(name);
                    stored = this.cachingService.storeClassAndGeneratedClasses("", sourceFileURL, clazz, classbytes, generatedClasses);
                } else {
                    this.weavingService.flushGeneratedClasses((ClassLoader)this.baseLoader);
                    if (Debug.DEBUG_CACHE) {
                        Debug.println("- AspectJAdaptor.storeClass() generatedClassesExistFor=true");
                    }
                }
            } else {
                stored = this.cachingService.storeClass("", sourceFileURL, clazz, classbytes);
                if (!stored && Debug.DEBUG_CACHE) {
                    Debug.println("E AspectJHook.storeClass() bundle=" + this.symbolicName + ", name=" + name);
                }
            }
        }
        if (Debug.DEBUG_CACHE) {
            Debug.println("< AspectJAdaptor.storeClass() stored=" + stored);
        }
        return stored;
    }

    public String toString() {
        return "AspectJAdaptor[" + this.symbolicName + "]";
    }

    public byte[] weaveClass(String name, byte[] bytes) {
        if (Debug.DEBUG_WEAVE) {
            Debug.println("> AspectJAdaptor.weaveClass() bundle=" + this.symbolicName + ", name=" + name + ", bytes=" + bytes.length);
        }
        byte[] newBytes = null;
        this.initialize();
        if (this.weavingService != null) {
            try {
                newBytes = this.weavingService.preProcess(name, bytes, (ClassLoader)this.baseLoader);
            }
            catch (IOException ex) {
                throw new ClassFormatError(ex.toString());
            }
        }
        if (Debug.DEBUG_WEAVE) {
            Debug.println("< AspectJAdaptor.weaveClass() newBytes=" + newBytes);
        }
        return newBytes;
    }

    private static class ThreadLocalSet
    extends ThreadLocal {
        private ThreadLocalSet() {
        }

        public boolean contains(Object obj) {
            Set set = (Set)this.get();
            return set.contains(obj);
        }

        public void put(Object obj) {
            Set set = (Set)this.get();
            if (set.contains(obj)) {
                throw new RuntimeException(obj.toString());
            }
            set.add(obj);
        }

        public void remove(Object obj) {
            Set set = (Set)this.get();
            if (!set.contains(obj)) {
                throw new RuntimeException(obj.toString());
            }
            set.remove(obj);
        }

        protected Object initialValue() {
            return new HashSet();
        }
    }
}

