/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Region;
import org.jboss.cache.RegionManager;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.EvictionRegionConfig;
import org.jboss.cache.eviction.ElementSizeAlgorithmConfig;
import org.jboss.cache.eviction.ElementSizePolicy;
import org.jboss.cache.eviction.EvictedEventNode;
import org.jboss.cache.eviction.EvictionActionPolicy;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.EvictionEvent;
import org.jboss.cache.eviction.EvictionPolicy;
import org.jboss.cache.eviction.ExpirationAlgorithmConfig;
import org.jboss.cache.eviction.ExpirationPolicy;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;
import org.jboss.cache.eviction.FIFOPolicy;
import org.jboss.cache.eviction.LFUAlgorithmConfig;
import org.jboss.cache.eviction.LFUPolicy;
import org.jboss.cache.eviction.LRUAlgorithmConfig;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.MRUAlgorithmConfig;
import org.jboss.cache.eviction.MRUPolicy;
import org.jboss.cache.eviction.NullEvictionAlgorithmConfig;
import org.jboss.cache.eviction.NullEvictionPolicy;
import org.jboss.cache.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionImpl
implements Region {
    private static final Log log = LogFactory.getLog(RegionImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final RegionManager regionManager;
    private Fqn fqn;
    private Region.Status status;
    private ClassLoader classLoader;
    private volatile BlockingQueue<EvictionEvent> evictionEventQueue = null;
    private int capacityWarnThreshold = 0;
    private EvictionRegionConfig evictionRegionConfig;
    private EvictionAlgorithm evictionAlgorithm;

    public RegionImpl(Fqn fqn, RegionManager regionManager) {
        this.fqn = fqn;
        this.regionManager = regionManager;
        this.status = !regionManager.isDefaultInactive() ? Region.Status.ACTIVE : Region.Status.INACTIVE;
    }

    public RegionImpl(EvictionRegionConfig config, Fqn fqn, RegionManager regionManager) {
        this(fqn, regionManager);
        this.evictionRegionConfig = config;
        this.createQueue();
    }

    @Override
    public Configuration getCacheConfiguration() {
        if (this.regionManager != null && this.regionManager.getCache() != null) {
            return this.regionManager.getCache().getConfiguration();
        }
        return null;
    }

    @Override
    public void registerContextClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void unregisterContextClassLoader() {
        this.classLoader = null;
    }

    @Override
    public void activate() {
        this.regionManager.activate(this.fqn);
        this.status = Region.Status.ACTIVE;
    }

    @Override
    public void activateIfEmpty() {
        this.regionManager.activateIfEmpty(this.fqn);
        this.status = Region.Status.ACTIVE;
    }

    @Override
    public void deactivate() {
        this.regionManager.deactivate(this.fqn);
        this.status = Region.Status.INACTIVE;
    }

    @Override
    public boolean isActive() {
        return this.status == Region.Status.ACTIVE;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public void processEvictionQueues() {
        if (trace) {
            log.trace((Object)("Processing eviction queue for region [" + this.getFqn() + "].  Queue size is " + this.evictionEventQueue.size()));
        }
        this.evictionAlgorithm.process(this.evictionEventQueue);
    }

    @Override
    public Fqn getFqn() {
        return this.fqn;
    }

    @Override
    public void setStatus(Region.Status status) {
        this.status = status;
    }

    @Override
    public Region.Status getStatus() {
        return this.status;
    }

    @Override
    public void setActive(boolean b) {
        this.status = b ? Region.Status.ACTIVE : Region.Status.INACTIVE;
    }

    public BlockingQueue<EvictionEvent> getEvictionEventQueue() {
        return this.evictionEventQueue;
    }

    @Override
    public void markNodeCurrentlyInUse(Fqn fqn, long timeout) {
        this.registerEvictionEvent(fqn, EvictionEvent.Type.MARK_IN_USE_EVENT, 0).setInUseTimeout(timeout);
    }

    @Override
    public void unmarkNodeCurrentlyInUse(Fqn fqn) {
        this.registerEvictionEvent(fqn, EvictionEvent.Type.UNMARK_USE_EVENT, 0);
    }

    public String toString() {
        return "RegionImpl{fqn=" + this.fqn + "; classloader=" + this.classLoader + "; status=" + (Object)((Object)this.status) + "; eviction=" + (this.evictionAlgorithm != null) + "; evictionQueueSize=" + (this.evictionAlgorithm == null ? "-1" : Integer.valueOf(this.evictionEventQueue.size())) + '}';
    }

    @Override
    public int compareTo(Region other) {
        return this.getFqn().compareTo(other.getFqn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegionImpl region = (RegionImpl)o;
        return !(this.fqn != null ? !this.fqn.equals(region.fqn) : region.fqn != null);
    }

    public int hashCode() {
        return this.fqn != null ? this.fqn.hashCode() : 0;
    }

    @Override
    public void resetEvictionQueues() {
        this.evictionEventQueue.clear();
        this.evictionAlgorithm.getEvictionQueue().clear();
    }

    @Override
    public void setEvictionRegionConfig(EvictionRegionConfig evictionRegionConfig) {
        if (trace) {
            log.trace((Object)("setEvictionRegionConfig called with " + evictionRegionConfig));
        }
        this.evictionRegionConfig = evictionRegionConfig;
        this.evictionAlgorithm = this.createEvictionAlgorithm(evictionRegionConfig.getEvictionAlgorithmConfig(), evictionRegionConfig.getEvictionActionPolicyClassName());
        if (this.evictionEventQueue == null) {
            this.createQueue();
        }
        this.evictionAlgorithm.initialize();
    }

    @Override
    public EvictionRegionConfig getEvictionRegionConfig() {
        return this.evictionRegionConfig;
    }

    @Override
    public EvictionEvent registerEvictionEvent(Fqn fqn, EvictionEvent.Type eventType) {
        return this.registerEvictionEvent(fqn, eventType, 0);
    }

    @Override
    public EvictionEvent registerEvictionEvent(Fqn fqn, EvictionEvent.Type eventType, int elementDifference) {
        if (this.evictionAlgorithm.canIgnoreEvent(eventType)) {
            return null;
        }
        EvictionEvent event = new EvictionEvent(fqn, eventType, elementDifference);
        this.registerEvictionEvent(event);
        return event;
    }

    private void registerEvictionEvent(EvictionEvent ee) {
        try {
            if (this.evictionEventQueue == null) {
                this.createQueue();
            }
            if (this.evictionEventQueue.size() > this.capacityWarnThreshold && log.isWarnEnabled()) {
                log.warn((Object)("putNodeEvent(): eviction node event queue size is at 98% threshold value of capacity: " + this.evictionRegionConfig.getEventQueueSize() + " Region: " + this.fqn + " You will need to reduce the wakeUpIntervalSeconds parameter."));
            }
            this.evictionEventQueue.put(ee);
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Interrupted on adding event", (Throwable)e);
            }
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createQueue() {
        if (this.evictionEventQueue == null) {
            if (this.evictionRegionConfig == null) {
                throw new IllegalArgumentException("null eviction configuration");
            }
            int size = this.evictionRegionConfig.getEventQueueSize();
            this.capacityWarnThreshold = 98 * size / 100 - 100;
            if (this.capacityWarnThreshold <= 0 && log.isWarnEnabled()) {
                log.warn((Object)("Capacity warn threshold used in eviction is smaller than 1. Defined Event queu size is:" + size));
            }
            RegionImpl regionImpl = this;
            synchronized (regionImpl) {
                if (this.evictionEventQueue == null) {
                    this.evictionEventQueue = new LinkedBlockingQueue<EvictionEvent>(size);
                }
            }
        }
    }

    private EvictionAlgorithm createEvictionAlgorithm(EvictionAlgorithmConfig algoConfig, String evictionActionPolicyClass) {
        if (trace) {
            log.trace((Object)("Creating eviction algorithm using config " + algoConfig));
        }
        if (algoConfig == null) {
            throw new IllegalArgumentException("Eviction algorithm class must not be null!");
        }
        if (evictionActionPolicyClass == null) {
            throw new IllegalArgumentException("Eviction action policy class must not be null!");
        }
        try {
            if (trace) {
                log.trace((Object)("Instantiating " + evictionActionPolicyClass));
            }
            EvictionActionPolicy actionPolicy = (EvictionActionPolicy)Util.getInstance(evictionActionPolicyClass);
            actionPolicy.setCache(this.regionManager.getCache());
            if (trace) {
                log.trace((Object)("Instantiating " + algoConfig.getEvictionAlgorithmClassName()));
            }
            EvictionAlgorithm algorithm = (EvictionAlgorithm)Util.getInstance(algoConfig.getEvictionAlgorithmClassName());
            algorithm.setEvictionActionPolicy(actionPolicy);
            algorithm.assignToRegion(this.fqn, this.regionManager.getCache(), algoConfig, this.regionManager.getConfiguration());
            return algorithm;
        }
        catch (Exception e) {
            log.fatal((Object)("Unable to instantiate eviction algorithm " + algoConfig.getEvictionAlgorithmClassName()), (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Region copy(Fqn newRoot) {
        RegionImpl clone = new RegionImpl(this.evictionRegionConfig, Fqn.fromRelativeFqn(newRoot, this.fqn), this.regionManager);
        clone.status = this.status;
        clone.createQueue();
        for (EvictionEvent een : this.evictionEventQueue) {
            clone.registerEvictionEvent(een.getFqn(), een.getEventType(), een.getElementDifference());
        }
        return clone;
    }

    @Override
    @Deprecated
    public void setEvictionPolicy(EvictionPolicyConfig evictionPolicyConfig) {
        try {
            EvictionRegionConfig erc = new EvictionRegionConfig(this.getFqn());
            String epClassName = evictionPolicyConfig.getEvictionPolicyClass();
            EvictionAlgorithmConfig eac = this.getEvictionAlgorithmConfig(epClassName);
            erc.setEvictionAlgorithmConfig(eac);
            if (!erc.isDefaultRegion()) {
                erc.setDefaults(this.regionManager.getConfiguration().getEvictionConfig().getDefaultEvictionRegionConfig());
            }
            this.setEvictionRegionConfig(erc);
        }
        catch (Exception e) {
            throw new CacheException(e);
        }
    }

    @Deprecated
    private EvictionAlgorithmConfig getEvictionAlgorithmConfig(String evictionPolicyClass) throws Exception {
        HashMap<String, Class<NullEvictionAlgorithmConfig>> legacyConfigMap = new HashMap<String, Class<NullEvictionAlgorithmConfig>>();
        legacyConfigMap.put(FIFOPolicy.class.getName(), FIFOAlgorithmConfig.class);
        legacyConfigMap.put(LRUPolicy.class.getName(), LRUAlgorithmConfig.class);
        legacyConfigMap.put(LFUPolicy.class.getName(), LFUAlgorithmConfig.class);
        legacyConfigMap.put(MRUPolicy.class.getName(), MRUAlgorithmConfig.class);
        legacyConfigMap.put(ExpirationPolicy.class.getName(), ExpirationAlgorithmConfig.class);
        legacyConfigMap.put(ElementSizePolicy.class.getName(), ElementSizeAlgorithmConfig.class);
        legacyConfigMap.put(NullEvictionPolicy.class.getName(), NullEvictionAlgorithmConfig.class);
        Class c = (Class)legacyConfigMap.get(evictionPolicyClass);
        if (c != null) {
            return (EvictionAlgorithmConfig)Util.getInstance(c);
        }
        final EvictionPolicy ep = (EvictionPolicy)Util.getInstance(evictionPolicyClass);
        ep.getEvictionAlgorithm();
        return new LRUAlgorithmConfig(){

            public String getEvictionAlgorithmClassName() {
                return ep.getEvictionAlgorithm().getClass().getName();
            }
        };
    }

    @Override
    @Deprecated
    public EvictionPolicyConfig getEvictionPolicyConfig() {
        return null;
    }

    @Override
    @Deprecated
    public EvictionPolicy getEvictionPolicy() {
        return null;
    }

    @Override
    @Deprecated
    public int nodeEventQueueSize() {
        BlockingQueue<EvictionEvent> q = this.getEvictionEventQueue();
        return q == null ? 0 : q.size();
    }

    @Override
    @Deprecated
    public EvictedEventNode takeLastEventNode() {
        try {
            EvictionEvent ee = this.getEvictionEventQueue().poll(0L, TimeUnit.SECONDS);
            if (ee instanceof EvictedEventNode) {
                return (EvictedEventNode)ee;
            }
            return new EvictedEventNode(ee);
        }
        catch (InterruptedException e) {
            log.debug((Object)"trace", (Throwable)e);
            return null;
        }
    }

    @Override
    @Deprecated
    public void putNodeEvent(EvictedEventNode event) {
        this.registerEvictionEvent(event);
    }

    @Override
    @Deprecated
    public Region clone() throws CloneNotSupportedException {
        return (Region)super.clone();
    }
}

