/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.ext;

import java.util.List;
import java.util.Map;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.util.ClassUtil;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;

public class PropertyChecker
implements DOMVisitBefore {
    @Override
    public void visitBefore(Element element, ExecutionContext execContext) throws SmooksException {
        BeanType beanType = this.getBeanType(element);
        boolean isPropertSpecified = DomUtils.getAttributeValue(element, "property") != null;
        boolean isSetterMethodSpecified = DomUtils.getAttributeValue(element, "setterMethod") != null;
        String bindingType = DomUtils.getName(element);
        if (isPropertSpecified && isSetterMethodSpecified) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'property' and a 'setterMethod' attribute.  Only one of both may be set.");
        }
        if (isPropertSpecified && beanType == BeanType.LIST) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'property' attribute.  This is not valid for a List target.");
        }
        if (isPropertSpecified && beanType == BeanType.ARRAY) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'property' attribute.  This is not valid for an Array target.");
        }
        if (isSetterMethodSpecified && beanType == BeanType.LIST) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'setterMethod' attribute.  This is not valid for a List target.");
        }
        if (isSetterMethodSpecified && beanType == BeanType.ARRAY) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding specifies a 'setterMethod' attribute.  This is not valid for an Array target.");
        }
        if (!isPropertSpecified && !isSetterMethodSpecified && beanType == BeanType.OTHER) {
            throw new SmooksConfigurationException("'" + bindingType + "' binding for bean class '" + this.getBeanTypeName(element) + "' must specify a 'property' or 'setterMethod' attribute.");
        }
    }

    private BeanType getBeanType(Element bindingElement) {
        String beanClassName = this.getBeanTypeName(bindingElement);
        if (beanClassName.endsWith("[]")) {
            return BeanType.ARRAY;
        }
        Class beanClass = this.getBeanClass(bindingElement);
        if (List.class.isAssignableFrom(beanClass)) {
            return BeanType.LIST;
        }
        if (Map.class.isAssignableFrom(beanClass)) {
            return BeanType.MAP;
        }
        return BeanType.OTHER;
    }

    private Class getBeanClass(Element bindingElement) {
        Class beanClass;
        String beanClassName = this.getBeanTypeName(bindingElement);
        try {
            beanClass = ClassUtil.forName(beanClassName, this.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SmooksConfigurationException("Bean class '" + beanClassName + "' not avilable on classpath.");
        }
        return beanClass;
    }

    private String getBeanTypeName(Element bindingElement) {
        return ((Element)bindingElement.getParentNode()).getAttribute("class");
    }

    private static enum BeanType {
        ARRAY,
        LIST,
        MAP,
        OTHER;

    }
}

