/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.ext;

import java.util.UUID;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.javabean.DataDecoder;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DecodeParamResolver
implements DOMVisitBefore {
    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        NodeList decodeParams = element.getElementsByTagNameNS(element.getNamespaceURI(), "decodeParam");
        if (decodeParams.getLength() > 0) {
            ExtensionContext extensionContext = ExtensionContext.getExtensionContext(executionContext);
            SmooksResourceConfiguration populatorConfig = extensionContext.getResourceStack().peek();
            SmooksResourceConfiguration decoderConfig = new SmooksResourceConfiguration();
            extensionContext.addResource(decoderConfig);
            try {
                String type = populatorConfig.getStringParameter("type");
                DataDecoder decoder = DataDecoder.Factory.create(type);
                String reType = UUID.randomUUID().toString();
                populatorConfig.removeParameter("type");
                populatorConfig.setParameter("type", reType);
                decoderConfig.setSelector("decoder:" + reType);
                decoderConfig.setTargetProfile(extensionContext.getDefaultProfile());
                decoderConfig.setResource(decoder.getClass().getName());
                int i = 0;
                while (i < decodeParams.getLength()) {
                    Element decoderParam = (Element)decodeParams.item(i);
                    decoderConfig.setParameter(decoderParam.getAttribute("name"), DomUtils.getAllText(decoderParam, true));
                    ++i;
                }
            }
            finally {
                extensionContext.getResourceStack().pop();
            }
        }
    }
}

