/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery.sax;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class TrackedStringWriter
extends StringWriter {
    private char[] lastWriteBuf;
    private int lastWriteOff;
    private int lastWriteLen;
    private List<WriteRecord> writeTrackingList;

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (cbuf == this.lastWriteBuf && off == this.lastWriteOff && len == this.lastWriteLen) {
            return;
        }
        if (this.lastWriteBuf != null) {
            if (this.writeTrackingList == null) {
                this.writeTrackingList = new ArrayList<WriteRecord>();
            } else if (this.isAlreadyWritten(cbuf, off, len)) {
                return;
            }
            this.writeTrackingList.add(new WriteRecord(this.lastWriteBuf, this.lastWriteOff, this.lastWriteLen));
        }
        super.write(cbuf, off, len);
        this.lastWriteBuf = cbuf;
        this.lastWriteOff = off;
        this.lastWriteLen = len;
    }

    private boolean isAlreadyWritten(char[] cbuf, int off, int len) {
        int trackListLen = this.writeTrackingList.size();
        int i = 0;
        while (i < trackListLen) {
            WriteRecord listEntry = this.writeTrackingList.get(i);
            if (cbuf == listEntry.lastWriteBuf && off == listEntry.lastWriteOff && len == listEntry.lastWriteLen) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class WriteRecord {
        private char[] lastWriteBuf;
        private int lastWriteOff;
        private int lastWriteLen;

        private WriteRecord(char[] lastWriteBuf, int lastWriteOff, int lastWriteLen) {
            this.lastWriteBuf = lastWriteBuf;
            this.lastWriteOff = lastWriteOff;
            this.lastWriteLen = lastWriteLen;
        }
    }
}

