/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ApplicationContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.FilterBypass;
import org.milyn.delivery.Visitor;
import org.milyn.dtd.DTDStore;
import org.milyn.event.types.ConfigBuilderEvent;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public abstract class AbstractContentDeliveryConfig
implements ContentDeliveryConfig {
    private ApplicationContext applicationContext;
    private Map<String, List<SmooksResourceConfiguration>> resourceConfigTable = new LinkedHashMap<String, List<SmooksResourceConfiguration>>();
    private Map objectsTable = new LinkedHashMap();
    private DTDStore.DTDObjectContainer dtd;
    private List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private Boolean isDefaultSerializationOn = null;
    private List<XMLReader> readerPool = new CopyOnWriteArrayList<XMLReader>();
    private int readerPoolSize;
    private static final Vector EMPTY_LIST = new Vector();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List getSmooksResourceConfigurations(String selector) {
        return this.resourceConfigTable.get(selector.toLowerCase());
    }

    public void setSmooksResourceConfigurations(Map<String, List<SmooksResourceConfiguration>> resourceConfigTable) {
        this.resourceConfigTable = resourceConfigTable;
    }

    @Override
    public Map<String, List<SmooksResourceConfiguration>> getSmooksResourceConfigurations() {
        return this.resourceConfigTable;
    }

    @Override
    public List getObjects(String selector) {
        Vector<Object> objects = (Vector<Object>)this.objectsTable.get(selector = selector.toLowerCase());
        if (objects == null) {
            List<SmooksResourceConfiguration> unitDefs = this.resourceConfigTable.get(selector);
            if (unitDefs != null && unitDefs.size() > 0) {
                objects = new Vector<Object>(unitDefs.size());
                if (this.applicationContext == null) {
                    throw new IllegalStateException("Call to getObjects() before the setApplicationContext() was called.");
                }
                int i = 0;
                while (i < unitDefs.size()) {
                    SmooksResourceConfiguration resConfig = unitDefs.get(i);
                    objects.add(this.applicationContext.getStore().getObject(resConfig));
                    ++i;
                }
            } else {
                objects = EMPTY_LIST;
            }
            this.objectsTable.put(selector, objects);
        }
        return objects;
    }

    @Override
    public DTDStore.DTDObjectContainer getDTD() {
        return this.dtd;
    }

    public void setDtd(DTDStore.DTDObjectContainer dtd) {
        this.dtd = dtd;
    }

    @Override
    public List<ConfigBuilderEvent> getConfigBuilderEvents() {
        return this.configBuilderEvents;
    }

    @Override
    public boolean isDefaultSerializationOn() {
        if (this.isDefaultSerializationOn == null) {
            this.isDefaultSerializationOn = ParameterAccessor.getBoolParameter("default.serialization.on", true, this);
        }
        return this.isDefaultSerializationOn;
    }

    public void initializeXMLReaderPool() {
        try {
            this.readerPoolSize = Integer.parseInt(ParameterAccessor.getStringParameter("reader.pool.size", "0", this).trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.readerPoolSize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLReader getXMLReader() throws SAXException {
        List<XMLReader> list = this.readerPool;
        synchronized (list) {
            if (!this.readerPool.isEmpty()) {
                return this.readerPool.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnXMLReader(XMLReader reader) {
        List<XMLReader> list = this.readerPool;
        synchronized (list) {
            if (this.readerPool.size() < this.readerPoolSize) {
                this.readerPool.add(reader);
            }
        }
    }

    protected FilterBypass getFilterBypass(ContentHandlerConfigMapTable ... visitorTables) {
        ContentHandlerConfigMapTable[] contentHandlerConfigMapTableArray = visitorTables;
        int n = visitorTables.length;
        int n2 = 0;
        while (n2 < n) {
            ContentHandlerConfigMapTable visitorTable = contentHandlerConfigMapTableArray[n2];
            if (visitorTable != null && visitorTable.getUserConfiguredCount() > 1) {
                return null;
            }
            ++n2;
        }
        HashSet<FilterBypass> bypassSet = new HashSet<FilterBypass>();
        ContentHandlerConfigMapTable[] contentHandlerConfigMapTableArray2 = visitorTables;
        int n3 = visitorTables.length;
        n = 0;
        while (n < n3) {
            ContentHandlerConfigMapTable visitorTable = contentHandlerConfigMapTableArray2[n];
            if (visitorTable != null && visitorTable.getUserConfiguredCount() == 1) {
                FilterBypass filterBypass = this.getFilterBypass(visitorTable);
                if (filterBypass != null) {
                    bypassSet.add(filterBypass);
                } else {
                    return null;
                }
            }
            ++n;
        }
        if (bypassSet.size() == 1) {
            return (FilterBypass)bypassSet.iterator().next();
        }
        return null;
    }

    private <T extends Visitor> FilterBypass getFilterBypass(ContentHandlerConfigMapTable<T> visitorTable) {
        Set<Map.Entry<String, List<ContentHandlerConfigMap<T>>>> entries = visitorTable.getTable().entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<T>>> entry : entries) {
            Visitor visitor;
            ContentHandlerConfigMap<T> configMap = entry.getValue().get(0);
            SmooksResourceConfiguration resourceConfig = configMap.getResourceConfig();
            if (resourceConfig.isDefaultResource()) continue;
            if (resourceConfig.getTargetElement().equals("#document") && (visitor = (Visitor)configMap.getContentHandler()) instanceof FilterBypass) {
                return (FilterBypass)((Object)visitor);
            }
            return null;
        }
        return null;
    }
}

