/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.util.Comparator;
import org.milyn.cdr.ProfileTargetingExpression;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.profile.ProfileSet;

public class SmooksResourceConfigurationSortComparator
implements Comparator {
    private ProfileSet profileSet;

    public SmooksResourceConfigurationSortComparator(ProfileSet profileSet) {
        this.profileSet = profileSet;
    }

    public int compare(Object configObj1, Object configObj2) {
        double config2Specificity;
        SmooksResourceConfiguration config1 = (SmooksResourceConfiguration)configObj1;
        SmooksResourceConfiguration config = (SmooksResourceConfiguration)configObj2;
        if (config1 == config) {
            return 0;
        }
        double config1Specificity = this.getSpecificity(config1);
        if (config1Specificity > (config2Specificity = this.getSpecificity(config))) {
            return -1;
        }
        if (config1Specificity < config2Specificity) {
            return 1;
        }
        return 0;
    }

    protected double getSpecificity(SmooksResourceConfiguration resourceConfig) {
        double specificity = 0.0;
        ProfileTargetingExpression[] profileTargetingExpressions = resourceConfig.getProfileTargetingExpressions();
        int i = 0;
        while (i < profileTargetingExpressions.length) {
            specificity += profileTargetingExpressions[i].getSpecificity(this.profileSet);
            ++i;
        }
        if (resourceConfig.isXmlDef()) {
            specificity += 10.0;
        } else if (resourceConfig.getSelector().equals("*")) {
            specificity += 5.0;
        } else {
            specificity += 100.0;
            if (resourceConfig.isSelectorContextual()) {
                int contextSpecificity = resourceConfig.getContextualSelector().length;
                specificity += (double)(10 * (contextSpecificity - 1));
            }
        }
        if (resourceConfig.getSelectorNamespaceURI() != null) {
            specificity += 10.0;
        }
        return specificity;
    }
}

