/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.milyn.annotation.AnnotatedClass;
import org.milyn.annotation.AnnotatedMethod;
import org.milyn.annotation.AnnotatedMethodImpl;
import org.milyn.annotation.AnnotationManager;

class AnnotatedClassImpl
implements AnnotatedClass {
    private final Class<?> theClass;
    private Map<Class<?>, Annotation> classToAnnotationMap = null;
    private Map<Method, AnnotatedMethod> methodToAnnotatedMap = null;
    private Annotation[] annotations = null;
    private AnnotatedMethod[] annotatedMethods = null;

    AnnotatedClassImpl(Class<?> theClass) {
        this.theClass = theClass;
    }

    private Map<Class<?>, Annotation> getAllAnnotationMap() {
        if (this.classToAnnotationMap == null) {
            this.classToAnnotationMap = this.getAllAnnotationMapCalculated();
        }
        return this.classToAnnotationMap;
    }

    private Map<Class<?>, Annotation> getAllAnnotationMapCalculated() {
        HashMap result = new HashMap();
        Class<?> superClass = this.getTheClass().getSuperclass();
        if (superClass != null) {
            this.fillAnnotationsForOneClass(result, superClass);
        }
        Object[] objectArray = this.getTheClass().getInterfaces();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = objectArray[n2];
            this.fillAnnotationsForOneClass(result, c);
            ++n2;
        }
        objectArray = this.getTheClass().getDeclaredAnnotations();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Object annotation = objectArray[n2];
            result.put(annotation.getClass().getInterfaces()[0], (Annotation)annotation);
            ++n2;
        }
        return result;
    }

    private void fillAnnotationsForOneClass(HashMap<Class<?>, Annotation> result, Class<?> baseClass) {
        this.addAnnotations(result, AnnotationManager.getAnnotatedClass(baseClass).getAllAnnotations());
    }

    private void addAnnotations(HashMap<Class<?>, Annotation> result, Annotation[] annotations) {
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation != null) {
                if (result.containsKey(annotation.getClass().getInterfaces()[0])) {
                    result.put(annotation.getClass().getInterfaces()[0], null);
                } else {
                    result.put(annotation.getClass().getInterfaces()[0], annotation);
                }
            }
            ++n2;
        }
    }

    @Override
    public Class<?> getTheClass() {
        return this.theClass;
    }

    @Override
    public Annotation[] getAllAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.getAllAnnotationsCalculated();
        }
        return this.annotations;
    }

    private Annotation[] getAllAnnotationsCalculated() {
        return this.getAllAnnotationMap().values().toArray(new Annotation[0]);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.getAllAnnotationMap().get(annotationClass);
    }

    private Map<Method, AnnotatedMethod> getMethodMap() {
        if (this.methodToAnnotatedMap == null) {
            this.methodToAnnotatedMap = this.getMethodMapCalculated();
        }
        return this.methodToAnnotatedMap;
    }

    private Map<Method, AnnotatedMethod> getMethodMapCalculated() {
        HashMap<Method, AnnotatedMethod> result = new HashMap<Method, AnnotatedMethod>();
        Method[] methodArray = this.getTheClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            result.put(method, new AnnotatedMethodImpl(this, method));
            ++n2;
        }
        return result;
    }

    @Override
    public AnnotatedMethod getAnnotatedMethod(Method method) {
        return this.getMethodMap().get(method);
    }

    @Override
    public AnnotatedMethod[] getAnnotatedMethods() {
        if (this.annotatedMethods == null) {
            this.annotatedMethods = this.getAnnotatedMethodsCalculated();
        }
        return this.annotatedMethods;
    }

    private AnnotatedMethod[] getAnnotatedMethodsCalculated() {
        Collection<AnnotatedMethod> values = this.getMethodMap().values();
        return values.toArray(new AnnotatedMethod[0]);
    }

    @Override
    public AnnotatedMethod getAnnotatedMethod(String name, Class<?>[] parameterType) {
        try {
            return this.getAnnotatedMethod(this.getTheClass().getMethod(name, parameterType));
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }
}

