/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.CompositeKeyFormat;
import com.sleepycat.persist.impl.PersistKeyBinding;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.model.FieldMetadata;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistComparator
implements Comparator<byte[]>,
Serializable {
    private static final long serialVersionUID = 5221576538843355317L;
    private String keyClassName;
    private String[] comositeFieldOrder;
    private transient PersistKeyBinding binding;

    public PersistComparator(String keyClassName, List<FieldMetadata> compositeKeyFields, PersistKeyBinding binding) {
        this.keyClassName = keyClassName;
        this.binding = binding;
        if (compositeKeyFields != null) {
            this.comositeFieldOrder = CompositeKeyFormat.getFieldNameArray(compositeKeyFields);
        }
    }

    @Override
    public int compare(byte[] b1, byte[] b2) {
        if (this.binding == null) {
            Class keyClass;
            try {
                keyClass = SimpleCatalog.classForName(this.keyClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            this.binding = new PersistKeyBinding(keyClass, this.comositeFieldOrder);
        }
        Comparable k1 = (Comparable)this.binding.bytesToObject(b1, 0, b1.length);
        Comparable k2 = (Comparable)this.binding.bytesToObject(b2, 0, b2.length);
        return k1.compareTo(k2);
    }
}

