/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.PropUtil;

public class Transaction {
    private Txn txn;
    private Environment env;
    private long id;
    private String name;

    Transaction(Environment env, Txn txn) {
        this.env = env;
        this.txn = txn;
        this.id = txn.getId();
    }

    public void abort() throws DatabaseException {
        try {
            this.checkEnv();
            this.env.removeReferringHandle(this);
            this.txn.abort(false);
            this.txn = null;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.env).invalidate(E);
            throw E;
        }
    }

    public long getId() throws DatabaseException {
        return this.id;
    }

    public void commit() throws DatabaseException {
        try {
            this.checkEnv();
            this.env.removeReferringHandle(this);
            this.txn.commit();
            this.txn = null;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.env).invalidate(E);
            throw E;
        }
    }

    public void commit(Durability durability) throws DatabaseException {
        this.doCommit(durability, false);
    }

    public void commitSync() throws DatabaseException {
        this.doCommit(TransactionConfig.SYNC, true);
    }

    public void commitNoSync() throws DatabaseException {
        this.doCommit(TransactionConfig.NO_SYNC, true);
    }

    public void commitWriteNoSync() throws DatabaseException {
        this.doCommit(TransactionConfig.WRITE_NO_SYNC, true);
    }

    public boolean getPrepared() {
        return this.txn.getPrepared();
    }

    private void doCommit(Durability durability, boolean explicitSync) throws DatabaseException {
        try {
            this.checkEnv();
            this.env.removeReferringHandle(this);
            if (explicitSync) {
                if (this.txn.getExplicitDurabilityConfigured()) {
                    throw new IllegalArgumentException("Mixed use of deprecated durability API for the transaction commit with the new durability API for TransactionConfig or MutableEnvironmentConfig");
                }
            } else if (this.txn.getExplicitSyncConfigured()) {
                throw new IllegalArgumentException("Mixed use of new durability API for the transaction commit with deprecated durability API for TransactionConfig or MutableEnvironmentConfig");
            }
            this.txn.commit(durability);
            this.txn = null;
        }
        catch (Error E) {
            DbInternal.envGetEnvironmentImpl(this.env).invalidate(E);
            throw E;
        }
    }

    public void setTxnTimeout(long timeOut) throws IllegalArgumentException, DatabaseException {
        this.checkEnv();
        this.txn.setTxnTimeout(PropUtil.microsToMillis(timeOut));
    }

    public void setLockTimeout(long timeOut) throws IllegalArgumentException, DatabaseException {
        this.checkEnv();
        this.txn.setLockTimeout(PropUtil.microsToMillis(timeOut));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        return ((Transaction)o).id == this.id;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Transaction id=\"");
        sb.append(this.id).append("\"");
        if (this.name != null) {
            sb.append(" name=\"");
            sb.append(this.name).append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    Locker getLocker() throws DatabaseException {
        if (this.txn == null) {
            throw new DatabaseException("Transaction " + this.id + " has been closed and is no longer" + " usable.");
        }
        return this.txn;
    }

    Txn getTxn() {
        return this.txn;
    }

    private void checkEnv() throws DatabaseException {
        EnvironmentImpl envImpl = this.env.getEnvironmentImpl();
        if (envImpl == null) {
            throw new DatabaseException("The environment has been closed.  This transaction is no longer usable.");
        }
        envImpl.checkIfInvalid();
    }
}

